/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingScope
implements SqlValidatorScope {
    protected final SqlValidatorScope parent;
    protected final SqlValidatorImpl validator;

    DelegatingScope(SqlValidatorScope parent) {
        assert (parent != null);
        this.validator = (SqlValidatorImpl)parent.getValidator();
        this.parent = parent;
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlValidatorNamespace resolve(String name, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        return this.parent.resolve(name, ancestorOut, offsetOut);
    }

    protected void addColumnNames(SqlValidatorNamespace ns, List<SqlMoniker> colNames) {
        RelDataType rowType;
        try {
            rowType = ns.getRowType();
        }
        catch (Error e) {
            return;
        }
        for (RelDataTypeField field : rowType.getFieldList()) {
            colNames.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
        }
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(List<SqlMoniker> result) {
        this.parent.findAliases(result);
    }

    @Override
    public String findQualifyingTableName(String columnName, SqlNode ctx) {
        return this.parent.findQualifyingTableName(columnName, ctx);
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        return this.parent.resolveColumn(name, ctx);
    }

    @Override
    public SqlValidatorNamespace getTableNamespace(List<String> names) {
        return this.parent.getTableNamespace(names);
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call instanceof SqlSelect) {
            return this.validator.getSelectScope((SqlSelect)call);
        }
        return this;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public SqlIdentifier fullyQualify(SqlIdentifier identifier) {
        if (identifier.isStar()) {
            return identifier;
        }
        switch (identifier.names.size()) {
            case 1: {
                String columnName = (String)identifier.names.get(0);
                String tableName = this.findQualifyingTableName(columnName, identifier);
                return this.resolveSqlIdentifier(tableName, columnName, identifier, false);
            }
            case 2: {
                String tableName = (String)identifier.names.get(0);
                String columnName = (String)identifier.names.get(1);
                return this.resolveSqlIdentifier(tableName, columnName, identifier, true);
            }
        }
        assert (identifier.names.size() > 0);
        return identifier;
    }

    @Override
    public void validateExpr(SqlNode expr) {
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        return this.parent.lookupWindow(name);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        return this.parent.getMonotonicity(expr);
    }

    @Override
    public SqlNodeList getOrderList() {
        return this.parent.getOrderList();
    }

    public SqlValidatorScope getParent() {
        return this.parent;
    }

    private SqlIdentifier resolveSqlIdentifier(String tableName, String columnName, SqlIdentifier identifier, boolean tblNamePrefixed) {
        SqlValidatorNamespace fromNs = this.resolve(tableName, null, null);
        if (fromNs == null) {
            SqlIdentifier id = identifier;
            if (tblNamePrefixed) {
                id = identifier.getComponent(0);
            }
            throw this.validator.newValidationError(id, Static.RESOURCE.tableNameNotFound(tableName));
        }
        RelDataType fromRowType = fromNs.getRowType();
        RelDataTypeField field = this.validator.catalogReader.field(fromRowType, columnName);
        if (field != null) {
            if (field.getName().startsWith("*") && !columnName.startsWith("*")) {
                if (this.getStarColumnCount(fromRowType) > 1) {
                    throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
                }
                return new SqlIdentifier((List<String>)ImmutableList.of((Object)tableName, (Object)field.getName()), identifier.getParserPosition());
            }
            if (tblNamePrefixed) {
                return identifier;
            }
            return new SqlIdentifier((List<String>)ImmutableList.of((Object)tableName, (Object)columnName), null, identifier.getParserPosition(), (List<SqlParserPos>)ImmutableList.of((Object)SqlParserPos.ZERO, (Object)identifier.getParserPosition()));
        }
        SqlIdentifier id = identifier;
        if (tblNamePrefixed) {
            id = identifier.getComponent(1);
        }
        throw this.validator.newValidationError(id, Static.RESOURCE.columnNotFoundInTable(columnName, tableName));
    }

    private int getStarColumnCount(RelDataType rowType) {
        int count = 0;
        for (String fieldName : rowType.getFieldNames()) {
            if (!fieldName.startsWith("*")) continue;
            ++count;
        }
        return count;
    }
}

