/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.io.StringReader;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import net.hydromatic.optiq.config.Lex;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlAbstractParserImpl;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.util.EigenbaseContextException;

public class SqlParser {
    public static final int DEFAULT_IDENTIFIER_MAX_LENGTH = 128;
    private final SqlAbstractParserImpl parser;
    private String originalInput;

    private SqlParser(String s, SqlAbstractParserImpl parser, ParserConfig config) {
        this(s, parser, config.getLex().quoting, config.getLex().unquotedCasing, config.getLex().quotedCasing, config.getIdentifierMaxLength());
    }

    private SqlParser(String s, SqlAbstractParserImpl parser, Quoting quoting, Casing unquotedCasing, Casing quotedCasing) {
        this(s, parser, quoting, unquotedCasing, quotedCasing, 128);
    }

    private SqlParser(String s, SqlAbstractParserImpl parser, Quoting quoting, Casing unquotedCasing, Casing quotedCasing, int identifierMaxLength) {
        this.originalInput = s;
        this.parser = parser;
        parser.setTabSize(1);
        parser.setQuotedCasing(quotedCasing);
        parser.setUnquotedCasing(unquotedCasing);
        parser.setIdentifierMaxLength(identifierMaxLength);
        switch (quoting) {
            case DOUBLE_QUOTE: {
                parser.switchTo("DQID");
                break;
            }
            case BACK_TICK: {
                parser.switchTo("BTID");
                break;
            }
            case BRACKET: {
                parser.switchTo("DEFAULT");
            }
        }
    }

    public static SqlParser create(String s) {
        return SqlParser.create(SqlParserImpl.FACTORY, s, new ParserConfigImpl(Lex.ORACLE, 128));
    }

    public static SqlParser create(SqlParserImplFactory parserFactory, String s, Quoting quoting, Casing unquotedCasing, Casing quotedCasing) {
        SqlAbstractParserImpl parser = parserFactory.getParser(new StringReader(s));
        return new SqlParser(s, parser, quoting, unquotedCasing, quotedCasing);
    }

    public static SqlParser create(SqlParserImplFactory parserFactory, String s, ParserConfig config) {
        SqlAbstractParserImpl parser = parserFactory.getParser(new StringReader(s));
        return new SqlParser(s, parser, config);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.parseSqlExpressionEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseStmt() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlAbstractParserImpl.Metadata getMetadata() {
        return this.parser.getMetadata();
    }

    public static class ParserConfigImpl
    implements ParserConfig {
        int identifierMaxLength;
        Lex lex;

        public ParserConfigImpl(Lex lex, int identifierMaxLength) {
            this.identifierMaxLength = identifierMaxLength;
            this.lex = lex;
        }

        public int getIdentifierMaxLength() {
            return this.identifierMaxLength;
        }

        public Casing getQuotedCasing() {
            return this.lex.quotedCasing;
        }

        public Casing getUnquotedCasing() {
            return this.lex.unquotedCasing;
        }

        public Quoting getQuoting() {
            return this.lex.quoting;
        }

        public Lex getLex() {
            return this.lex;
        }
    }

    public static interface ParserConfig {
        public int getIdentifierMaxLength();

        public Casing getQuotedCasing();

        public Casing getUnquotedCasing();

        public Quoting getQuoting();

        public Lex getLex();
    }
}

