/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class SqlMonotonicBinaryOperator
extends SqlBinaryOperator {
    public SqlMonotonicBinaryOperator(String name, SqlKind kind, int prec, boolean isLeftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, prec, isLeftAssoc, returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        SqlMonotonicity mono0 = scope.getMonotonicity((SqlNode)call.operand(0));
        SqlMonotonicity mono1 = scope.getMonotonicity((SqlNode)call.operand(1));
        if (mono1 == SqlMonotonicity.CONSTANT && mono0 == SqlMonotonicity.CONSTANT) {
            return SqlMonotonicity.CONSTANT;
        }
        if (mono1 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-") || this.getName().equals("+")) {
                return mono0;
            }
            assert (this.getName().equals("*"));
            if (call.operand(1) instanceof SqlLiteral) {
                SqlLiteral literal = (SqlLiteral)call.operand(1);
                switch (literal.signum()) {
                    case -1: {
                        return mono0.reverse();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono0;
            }
            return mono0;
        }
        if (mono0 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-")) {
                return mono1.reverse();
            }
            if (this.getName().equals("+")) {
                return mono1;
            }
            assert (this.getName().equals("*"));
            if (call.operand(0) instanceof SqlLiteral) {
                SqlLiteral literal = (SqlLiteral)call.operand(0);
                switch (literal.signum()) {
                    case -1: {
                        return mono1.reverse();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono1;
            }
        }
        if (this.getName().equals("+")) {
            if (mono0 == mono1) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("-")) {
            if (mono0 == mono1.reverse()) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.reverse().unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("*")) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return super.getMonotonicity(call, scope);
    }
}

