/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlLikeOperator
extends SqlSpecialOperator {
    private final boolean negated;

    SqlLikeOperator(String name, SqlKind kind, boolean negated) {
        super(name, kind, 30, false, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME_SAME);
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        switch (callBinding.getOperandCount()) {
            case 2: {
                if (OperandTypes.STRING_SAME_SAME.checkOperandTypes(callBinding, throwOnFailure)) break;
                return false;
            }
            case 3: {
                if (OperandTypes.STRING_SAME_SAME_SAME.checkOperandTypes(callBinding, throwOnFailure)) break;
                return false;
            }
            default: {
                throw Util.newInternal("unexpected number of args to " + callBinding.getCall());
            }
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.getCall().getOperandList(), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (call.operandCount() == 3) {
            writer.sep("ESCAPE");
            ((SqlNode)call.operand(2)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(frame);
    }

    @Override
    public int reduceExpr(int opOrdinal, List<Object> list) {
        int end;
        SqlNode[] operands;
        SqlOperator op2;
        Object o;
        SqlNode exp0 = (SqlNode)list.get(opOrdinal - 1);
        SqlOperator op = ((SqlParserUtil.ToTreeListItem)list.get(opOrdinal)).getOperator();
        assert (op instanceof SqlLikeOperator);
        SqlNode exp1 = SqlParserUtil.toTreeEx(list, opOrdinal + 1, this.getRightPrec(), SqlKind.ESCAPE);
        SqlNode exp2 = null;
        if (opOrdinal + 2 < list.size() && (o = list.get(opOrdinal + 2)) instanceof SqlParserUtil.ToTreeListItem && (op2 = ((SqlParserUtil.ToTreeListItem)o).getOperator()).getKind() == SqlKind.ESCAPE) {
            exp2 = SqlParserUtil.toTreeEx(list, opOrdinal + 3, this.getRightPrec(), SqlKind.ESCAPE);
        }
        if (exp2 != null) {
            operands = new SqlNode[]{exp0, exp1, exp2};
            end = opOrdinal + 4;
        } else {
            operands = new SqlNode[]{exp0, exp1};
            end = opOrdinal + 2;
        }
        SqlCall call = this.createCall(SqlParserPos.ZERO, operands);
        SqlParserUtil.replaceSublist(list, opOrdinal - 1, end, call);
        return opOrdinal - 1;
    }
}

