/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.ImmutableNullableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlOrderBy
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new Operator(){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlOrderBy(pos, operands[0], (SqlNodeList)operands[1], operands[2], operands[3]);
        }
    };
    public final SqlNode query;
    public final SqlNodeList orderList;
    public final SqlNode offset;
    public final SqlNode fetch;

    public SqlOrderBy(SqlParserPos pos, SqlNode query, SqlNodeList orderList, SqlNode offset, SqlNode fetch) {
        super(pos);
        this.query = query;
        this.orderList = orderList;
        this.offset = offset;
        this.fetch = fetch;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.ORDER_BY;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.query, this.orderList, this.offset, this.fetch);
    }

    private static class Operator
    extends SqlSpecialOperator {
        private Operator() {
            super("ORDER BY", SqlKind.ORDER_BY, 0);
        }

        public SqlSyntax getSyntax() {
            return SqlSyntax.POSTFIX;
        }

        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlOrderBy orderBy = (SqlOrderBy)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY);
            orderBy.query.unparse(writer, this.getLeftPrec(), this.getRightPrec());
            if (orderBy.orderList != SqlNodeList.EMPTY) {
                writer.sep(this.getName());
                SqlWriter.Frame listFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST);
                this.unparseListClause(writer, orderBy.orderList);
                writer.endList(listFrame);
            }
            if (orderBy.offset != null) {
                SqlWriter.Frame frame2 = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
                writer.newlineAndIndent();
                writer.keyword("OFFSET");
                orderBy.offset.unparse(writer, -1, -1);
                writer.keyword("ROWS");
                writer.endList(frame2);
            }
            if (orderBy.fetch != null) {
                SqlWriter.Frame frame3 = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
                writer.newlineAndIndent();
                writer.keyword("FETCH");
                writer.keyword("NEXT");
                orderBy.fetch.unparse(writer, -1, -1);
                writer.keyword("ROWS");
                writer.keyword("ONLY");
                writer.endList(frame3);
            }
            writer.endList(frame);
        }
    }
}

