/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.sql.JoinConditionType;
import org.eigenbase.sql.JoinType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.ImmutableNullableList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJoin
extends SqlCall {
    public static final SqlJoinOperator OPERATOR = new SqlJoinOperator();
    SqlNode left;
    SqlLiteral natural;
    SqlLiteral joinType;
    SqlNode right;
    SqlLiteral conditionType;
    SqlNode condition;

    public SqlJoin(SqlParserPos pos, SqlNode left, SqlLiteral natural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, SqlNode condition) {
        super(pos);
        this.left = left;
        this.natural = natural;
        this.joinType = joinType;
        this.right = right;
        this.conditionType = conditionType;
        this.condition = condition;
        assert (natural.getTypeName() == SqlTypeName.BOOLEAN);
        assert (conditionType != null);
        assert (conditionType.symbolValue() instanceof JoinConditionType);
        assert (joinType != null);
        assert (joinType.symbolValue() instanceof JoinType);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.JOIN;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.left, this.natural, this.joinType, this.right, this.conditionType, this.condition);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.natural = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.condition = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final SqlNode getCondition() {
        return this.condition;
    }

    public final JoinConditionType getConditionType() {
        return (JoinConditionType)this.conditionType.symbolValue();
    }

    public SqlLiteral getConditionTypeNode() {
        return this.conditionType;
    }

    public final JoinType getJoinType() {
        return (JoinType)this.joinType.symbolValue();
    }

    public SqlLiteral getJoinTypeNode() {
        return this.joinType;
    }

    public final SqlNode getLeft() {
        return this.left;
    }

    public void setLeft(SqlNode left) {
        this.left = left;
    }

    public final boolean isNatural() {
        return this.natural.booleanValue();
    }

    public final SqlLiteral isNaturalNode() {
        return this.natural;
    }

    public final SqlNode getRight() {
        return this.right;
    }

    public void setRight(SqlNode right) {
        this.right = right;
    }

    public static class SqlJoinOperator
    extends SqlOperator {
        private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("USING");

        private SqlJoinOperator() {
            super("JOIN", SqlKind.JOIN, 16, true, null, null, null);
        }

        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            return new SqlJoin(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], operands[3], (SqlLiteral)operands[4], operands[5]);
        }

        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlJoin join = (SqlJoin)call;
            join.left.unparse(writer, leftPrec, this.getLeftPrec());
            String natural = "";
            if (join.isNatural()) {
                natural = "NATURAL ";
            }
            switch (join.getJoinType()) {
                case COMMA: {
                    writer.sep(",", true);
                    break;
                }
                case CROSS: {
                    writer.sep(natural + "CROSS JOIN");
                    break;
                }
                case FULL: {
                    writer.sep(natural + "FULL JOIN");
                    break;
                }
                case INNER: {
                    writer.sep(natural + "INNER JOIN");
                    break;
                }
                case LEFT: {
                    writer.sep(natural + "LEFT JOIN");
                    break;
                }
                case RIGHT: {
                    writer.sep(natural + "RIGHT JOIN");
                    break;
                }
                default: {
                    throw Util.unexpected(join.getJoinType());
                }
            }
            join.right.unparse(writer, this.getRightPrec(), rightPrec);
            if (join.condition != null) {
                switch (join.getConditionType()) {
                    case USING: {
                        writer.keyword("USING");
                        assert (join.condition instanceof SqlNodeList);
                        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
                        join.condition.unparse(writer, 0, 0);
                        writer.endList(frame);
                        break;
                    }
                    case ON: {
                        writer.keyword("ON");
                        join.condition.unparse(writer, leftPrec, rightPrec);
                        break;
                    }
                    default: {
                        throw Util.unexpected(join.getConditionType());
                    }
                }
            }
        }
    }
}

