/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFunction
extends SqlOperator {
    private final SqlFunctionCategory category;
    private final SqlIdentifier sqlIdentifier;
    private final List<RelDataType> paramTypes;

    public SqlFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, null, category);
        assert (category != SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR || returnTypeInference != null);
    }

    public SqlFunction(SqlIdentifier sqlIdentifier, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory funcType) {
        this(Util.last(sqlIdentifier.names), sqlIdentifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, funcType);
    }

    protected SqlFunction(String name, SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory category) {
        super(name, kind, 100, 100, returnTypeInference, operandTypeInference, operandTypeChecker);
        this.sqlIdentifier = sqlIdentifier;
        this.category = category;
        ImmutableList immutableList = this.paramTypes = paramTypes == null ? null : ImmutableList.copyOf(paramTypes);
        assert (category != null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public SqlIdentifier getNameAsId() {
        if (this.sqlIdentifier != null) {
            return this.sqlIdentifier;
        }
        return new SqlIdentifier(this.getName(), SqlParserPos.ZERO);
    }

    public List<RelDataType> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    public SqlFunctionCategory getFunctionType() {
        return this.category;
    }

    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        this.validateQuantifier(validator, call);
    }

    protected void validateQuantifier(SqlValidator validator, SqlCall call) {
        if (null != call.getFunctionQuantifier() && !this.isQuantifierAllowed()) {
            throw validator.newValidationError(call.getFunctionQuantifier(), Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.deriveType(validator, scope, call, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call, boolean convertRowArgToColumnList) {
        List<SqlNode> operands = call.getOperandList();
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        validator.pushFunctionCall();
        try {
            RelDataType relDataType;
            ImmutableList.Builder argTypeBuilder = ImmutableList.builder();
            boolean containsRowArg = false;
            for (SqlNode operand : operands) {
                RelDataType nodeType;
                if (operand.getKind() == SqlKind.ROW && convertRowArgToColumnList) {
                    containsRowArg = true;
                    RelDataTypeFactory typeFactory = validator.getTypeFactory();
                    nodeType = typeFactory.createSqlType(SqlTypeName.COLUMN_LIST);
                } else {
                    nodeType = validator.deriveType(operandScope, operand);
                }
                validator.setValidatedNodeType(operand, nodeType);
                argTypeBuilder.add((Object)nodeType);
            }
            ImmutableList argTypes = argTypeBuilder.build();
            SqlFunction function = SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)argTypes, this.getFunctionType());
            if (containsRowArg) {
                if (function == null && SqlUtil.matchRoutinesByParameterCount(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)argTypes, this.getFunctionType())) {
                    for (SqlNode operand : operands) {
                        if (operand.getKind() != SqlKind.ROW) continue;
                        validator.removeValidatedNodeType(operand);
                    }
                    relDataType = this.deriveType(validator, scope, call, false);
                    return relDataType;
                }
                if (function != null) {
                    validator.validateColumnListParams(function, (List<RelDataType>)argTypes, operands);
                }
            }
            if (this.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
                relDataType = validator.deriveConstructorType(scope, call, this, function, (List<RelDataType>)argTypes);
                return relDataType;
            }
            if (function == null) {
                throw validator.handleUnresolvedFunction(call, this, (List<RelDataType>)argTypes);
            }
            ((SqlBasicCall)call).setOperator(function);
            relDataType = function.validateOperands(validator, operandScope, call);
            return relDataType;
        }
        finally {
            validator.popFunctionCall();
        }
    }
}

