/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDialect {
    public static final SqlDialect DUMMY = DatabaseProduct.UNKNOWN.getDialect();
    public static final SqlDialect EIGENBASE = DatabaseProduct.LUCIDDB.getDialect();
    private final String identifierQuoteString;
    private final String identifierEndQuoteString;
    private final String identifierEscapedQuote;
    private final DatabaseProduct databaseProduct;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static SqlDialect create(DatabaseMetaData databaseMetaData) {
        String databaseProductName;
        String identifierQuoteString;
        try {
            identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            throw FakeUtil.newInternal(e, "while quoting identifier");
        }
        try {
            databaseProductName = databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw FakeUtil.newInternal(e, "while detecting database product");
        }
        DatabaseProduct databaseProduct = SqlDialect.getProduct(databaseProductName, null);
        return new SqlDialect(databaseProduct, databaseProductName, identifierQuoteString);
    }

    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString) {
        assert (databaseProduct != null);
        assert (databaseProductName != null);
        this.databaseProduct = databaseProduct;
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        this.identifierEndQuoteString = identifierQuoteString == null ? null : (identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString;
    }

    public static DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName = productName.toUpperCase();
        if (productName.equals("ACCESS")) {
            return DatabaseProduct.ACCESS;
        }
        if (upperProductName.trim().equals("APACHE DERBY")) {
            return DatabaseProduct.DERBY;
        }
        if (upperProductName.trim().equals("DBMS:CLOUDSCAPE")) {
            return DatabaseProduct.DERBY;
        }
        if (productName.startsWith("DB2")) {
            return DatabaseProduct.DB2;
        }
        if (upperProductName.contains("FIREBIRD")) {
            return DatabaseProduct.FIREBIRD;
        }
        if (productName.equals("Hive")) {
            return DatabaseProduct.HIVE;
        }
        if (productName.startsWith("Informix")) {
            return DatabaseProduct.INFORMIX;
        }
        if (upperProductName.equals("INGRES")) {
            return DatabaseProduct.INGRES;
        }
        if (productName.equals("Interbase")) {
            return DatabaseProduct.INTERBASE;
        }
        if (upperProductName.equals("LUCIDDB")) {
            return DatabaseProduct.LUCIDDB;
        }
        if (upperProductName.contains("SQL SERVER")) {
            return DatabaseProduct.MSSQL;
        }
        if (upperProductName.contains("PARACCEL")) {
            return DatabaseProduct.PARACCEL;
        }
        if (productName.equals("Oracle")) {
            return DatabaseProduct.ORACLE;
        }
        if (productName.equals("Phoenix")) {
            return DatabaseProduct.PHOENIX;
        }
        if (upperProductName.contains("POSTGRE")) {
            return DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.contains("NETEZZA")) {
            return DatabaseProduct.NETEZZA;
        }
        if (upperProductName.equals("MYSQL (INFOBRIGHT)")) {
            return DatabaseProduct.INFOBRIGHT;
        }
        if (upperProductName.equals("MYSQL")) {
            return DatabaseProduct.MYSQL;
        }
        if (productName.startsWith("HP Neoview")) {
            return DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.contains("SYBASE")) {
            return DatabaseProduct.SYBASE;
        }
        if (upperProductName.contains("TERADATA")) {
            return DatabaseProduct.TERADATA;
        }
        if (upperProductName.contains("HSQL")) {
            return DatabaseProduct.HSQLDB;
        }
        if (upperProductName.contains("VERTICA")) {
            return DatabaseProduct.VERTICA;
        }
        return DatabaseProduct.UNKNOWN;
    }

    public String quoteIdentifier(String val) {
        if (this.identifierQuoteString == null) {
            return val;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        return this.identifierQuoteString + val2 + this.identifierEndQuoteString;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null) {
            buf.append(val);
            return buf;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        buf.append(this.identifierQuoteString);
        buf.append(val2);
        buf.append(this.identifierEndQuoteString);
        return buf;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, List<String> identifiers) {
        int i = 0;
        for (String identifier : identifiers) {
            if (i++ > 0) {
                buf.append('.');
            }
            this.quoteIdentifier(buf, identifier);
        }
        return buf;
    }

    public boolean identifierNeedsToBeQuoted(String val) {
        return !Pattern.compile("^[A-Z_$0-9]+").matcher(val).matches();
    }

    public String quoteStringLiteral(String val) {
        if (SqlDialect.containsNonAscii(val)) {
            StringBuilder buf = new StringBuilder();
            this.quoteStringLiteralUnicode(buf, val);
            return buf.toString();
        }
        val = FakeUtil.replace(val, "'", "''");
        return "'" + val + "'";
    }

    private static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public String unquoteStringLiteral(String val) {
        if (val != null && val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'') {
            if (val.length() > 2) {
                val = FakeUtil.replace(val, "''", "'");
                return val.substring(1, val.length() - 1);
            }
            return "";
        }
        return val;
    }

    protected boolean allowsAs() {
        switch (this.databaseProduct) {
            case ORACLE: 
            case HIVE: {
                return false;
            }
        }
        return true;
    }

    protected boolean requiresAliasForFromItems() {
        return this.getDatabaseProduct() == DatabaseProduct.POSTGRESQL;
    }

    public String quoteTimestampLiteral(Timestamp timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-DD HH:mm:SS''");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(timestamp);
    }

    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public boolean supportsCharSet() {
        switch (this.databaseProduct) {
            case MYSQL: 
            case HSQLDB: 
            case PHOENIX: {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseProduct {
        ACCESS("Access", "\""),
        MSSQL("Microsoft SQL Server", "["),
        MYSQL("MySQL", "`"),
        ORACLE("Oracle", "\""),
        DERBY("Apache Derby", null),
        DB2("IBM DB2", null),
        FIREBIRD("Firebird", null),
        HIVE("Apache Hive", null),
        INFORMIX("Informix", null),
        INGRES("Ingres", null),
        LUCIDDB("LucidDB", "\""),
        INTERBASE("Interbase", null),
        PHOENIX("Phoenix", "\""),
        POSTGRESQL("PostgreSQL", "\""),
        NETEZZA("Netezza", "\""),
        INFOBRIGHT("Infobright", "`"),
        NEOVIEW("Neoview", null),
        SYBASE("Sybase", null),
        TERADATA("Teradata", "\""),
        HSQLDB("Hsqldb", null),
        VERTICA("Vertica", "\""),
        SQLSTREAM("SQLstream", "\""),
        PARACCEL("Paraccel", "\""),
        UNKNOWN("Unknown", "`");

        private SqlDialect dialect = null;
        private String databaseProductName;
        private String quoteString;

        private DatabaseProduct(String databaseProductName, String quoteString) {
            this.databaseProductName = databaseProductName;
            this.quoteString = quoteString;
        }

        public SqlDialect getDialect() {
            if (this.dialect == null) {
                this.dialect = new SqlDialect(this, this.databaseProductName, this.quoteString);
            }
            return this.dialect;
        }
    }

    public static class FakeUtil {
        public static Error newInternal(Throwable e, String s) {
            String message = "Internal error: \u0000" + s;
            AssertionError ae = new AssertionError((Object)message);
            ((Throwable)((Object)ae)).initCause(e);
            return ae;
        }

        public static String replace(String s, String find, String replace) {
            int found = s.indexOf(find);
            if (found == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder(s.length());
            int start = 0;
            while (true) {
                if (start < found) {
                    sb.append(s.charAt(start));
                    ++start;
                    continue;
                }
                if (found == s.length()) break;
                sb.append(replace);
                found = s.indexOf(find, start += find.length());
                if (found != -1) continue;
                found = s.length();
            }
            return sb.toString();
        }
    }
}

