/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Locale;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.util.SaffronProperties;
import org.eigenbase.util.SerializableCharset;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

public class SqlCollation
implements Serializable {
    public static final SqlCollation COERCIBLE = new SqlCollation(Coercibility.COERCIBLE);
    public static final SqlCollation IMPLICIT = new SqlCollation(Coercibility.IMPLICIT);
    protected final String collationName;
    protected final SerializableCharset wrappedCharset;
    protected final Locale locale;
    protected final String strength;
    private final Coercibility coercibility;

    public SqlCollation(String collation, Coercibility coercibility) {
        this.coercibility = coercibility;
        SqlParserUtil.ParsedCollation parseValues = SqlParserUtil.parseCollation(collation);
        Charset charset = parseValues.getCharset();
        this.wrappedCharset = SerializableCharset.forCharset(charset);
        this.locale = parseValues.getLocale();
        this.strength = parseValues.getStrength();
        String c = charset.name().toUpperCase() + "$" + this.locale.toString();
        if (this.strength != null && this.strength.length() > 0) {
            c = c + "$" + this.strength;
        }
        this.collationName = c;
    }

    public SqlCollation(Coercibility coercibility) {
        this(SaffronProperties.instance().defaultCollation.get(), coercibility);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SqlCollation && this.collationName.equals(((SqlCollation)o).collationName);
    }

    public int hashCode() {
        return this.collationName.hashCode();
    }

    public static SqlCollation getCoercibilityDyadicOperator(SqlCollation col1, SqlCollation col2) {
        return SqlCollation.getCoercibilityDyadic(col1, col2);
    }

    public static SqlCollation getCoercibilityDyadicOperatorThrows(SqlCollation col1, SqlCollation col2) {
        SqlCollation ret = SqlCollation.getCoercibilityDyadic(col1, col2);
        if (null == ret) {
            throw Static.RESOURCE.invalidCompare(col1.collationName, "" + (Object)((Object)col1.coercibility), col2.collationName, "" + (Object)((Object)col2.coercibility)).ex();
        }
        return ret;
    }

    public static String getCoercibilityDyadicComparison(SqlCollation col1, SqlCollation col2) {
        return SqlCollation.getCoercibilityDyadicOperatorThrows((SqlCollation)col1, (SqlCollation)col2).collationName;
    }

    protected static SqlCollation getCoercibilityDyadic(SqlCollation col1, SqlCollation col2) {
        assert (null != col1);
        assert (null != col2);
        Coercibility coercibility1 = col1.getCoercibility();
        Coercibility coercibility2 = col2.getCoercibility();
        switch (coercibility1) {
            case COERCIBLE: {
                switch (coercibility2) {
                    case COERCIBLE: {
                        return new SqlCollation(col2.collationName, Coercibility.COERCIBLE);
                    }
                    case IMPLICIT: {
                        return new SqlCollation(col2.collationName, Coercibility.IMPLICIT);
                    }
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return new SqlCollation(col2.collationName, Coercibility.EXPLICIT);
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case IMPLICIT: {
                switch (coercibility2) {
                    case COERCIBLE: {
                        return new SqlCollation(col1.collationName, Coercibility.IMPLICIT);
                    }
                    case IMPLICIT: {
                        if (col1.collationName.equals(col2.collationName)) {
                            return new SqlCollation(col2.collationName, Coercibility.IMPLICIT);
                        }
                        return null;
                    }
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return new SqlCollation(col2.collationName, Coercibility.EXPLICIT);
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case NONE: {
                switch (coercibility2) {
                    case COERCIBLE: 
                    case IMPLICIT: 
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return new SqlCollation(col2.collationName, Coercibility.EXPLICIT);
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case EXPLICIT: {
                switch (coercibility2) {
                    case COERCIBLE: 
                    case IMPLICIT: 
                    case NONE: {
                        return new SqlCollation(col1.collationName, Coercibility.EXPLICIT);
                    }
                    case EXPLICIT: {
                        if (col1.collationName.equals(col2.collationName)) {
                            return new SqlCollation(col2.collationName, Coercibility.EXPLICIT);
                        }
                        throw Static.RESOURCE.differentCollations(col1.collationName, col2.collationName).ex();
                    }
                }
                throw Util.unexpected(coercibility2);
            }
        }
        throw Util.unexpected(coercibility1);
    }

    public String toString() {
        return "COLLATE " + this.collationName;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("COLLATE");
        writer.identifier(this.collationName);
    }

    public Charset getCharset() {
        return this.wrappedCharset.getCharset();
    }

    public final String getCollationName() {
        return this.collationName;
    }

    public final Coercibility getCoercibility() {
        return this.coercibility;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Coercibility {
        EXPLICIT,
        IMPLICIT,
        COERCIBLE,
        NONE;

    }
}

