/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.sarg.SargExpr;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargInterval;
import org.eigenbase.sarg.SargIntervalSequence;
import org.eigenbase.sarg.SargSetOperator;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SargSetExpr
implements SargExpr {
    private final SargFactory factory;
    private final RelDataType dataType;
    private final SargSetOperator setOp;
    private final List<SargExpr> children;

    SargSetExpr(SargFactory factory, RelDataType dataType, SargSetOperator setOp) {
        this.factory = factory;
        this.dataType = dataType;
        this.setOp = setOp;
        this.children = new ArrayList<SargExpr>();
    }

    public List<SargExpr> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public void addChild(SargExpr child) {
        assert (child.getDataType() == this.dataType);
        if (this.setOp == SargSetOperator.COMPLEMENT) assert (this.children.isEmpty());
        this.children.add(child);
    }

    @Override
    public SargFactory getFactory() {
        return this.factory;
    }

    @Override
    public RelDataType getDataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.setOp);
        sb.append("(");
        for (SargExpr child : this.children) {
            sb.append(" ");
            sb.append(child);
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public SargIntervalSequence evaluate() {
        if (this.setOp == SargSetOperator.COMPLEMENT) {
            assert (this.children.size() == 1);
            SargExpr child = this.children.get(0);
            return child.evaluateComplemented();
        }
        List<SargIntervalSequence> list = this.evaluateChildren(this);
        switch (this.setOp) {
            case UNION: {
                return this.evaluateUnion(list);
            }
            case INTERSECTION: {
                return this.evaluateIntersection(list);
            }
        }
        throw Util.newInternal(this.setOp.toString());
    }

    private List<SargIntervalSequence> evaluateChildren(SargSetExpr setExpr) {
        ArrayList<SargIntervalSequence> list = new ArrayList<SargIntervalSequence>();
        for (SargExpr child : setExpr.children) {
            SargIntervalSequence newSeq = child.evaluate();
            list.add(newSeq);
        }
        return list;
    }

    @Override
    public void collectDynamicParams(Set<RexDynamicParam> dynamicParams) {
        for (SargExpr child : this.children) {
            child.collectDynamicParams(dynamicParams);
        }
    }

    private SargIntervalSequence evaluateUnion(List<SargIntervalSequence> list) {
        SargIntervalSequence seq = new SargIntervalSequence();
        TreeSet<SargInterval> intervals = new TreeSet<SargInterval>(IntervalComparator.INSTANCE);
        for (SargIntervalSequence childSeq : list) {
            intervals.addAll(childSeq.getList());
        }
        SargInterval accumulator = null;
        for (SargInterval interval : intervals) {
            assert (!interval.isEmpty());
            if (accumulator == null) {
                accumulator = new SargInterval(this.factory, this.getDataType());
                accumulator.copyFrom(interval);
                seq.addInterval(accumulator);
                continue;
            }
            if (accumulator.contains(interval)) continue;
            int c = interval.getLowerBound().compareTo(accumulator.getUpperBound());
            if (c > 0 && interval.getLowerBound().isTouching(accumulator.getUpperBound())) {
                c = -1;
            }
            if (c <= 0) {
                accumulator.upperBound.copyFrom(interval.getUpperBound());
                continue;
            }
            accumulator = new SargInterval(this.factory, this.getDataType());
            accumulator.copyFrom(interval);
            seq.addInterval(accumulator);
        }
        return seq;
    }

    private SargIntervalSequence evaluateIntersection(List<SargIntervalSequence> list) {
        SargIntervalSequence seq = null;
        if (list.isEmpty()) {
            seq = new SargIntervalSequence();
            seq.addInterval(new SargInterval(this.factory, this.getDataType()));
            return seq;
        }
        for (SargIntervalSequence newSeq : list) {
            if (seq == null) {
                seq = newSeq;
                continue;
            }
            this.intersectSequences(seq, newSeq);
        }
        return seq;
    }

    private void intersectSequences(SargIntervalSequence targetSeq, SargIntervalSequence sourceSeq) {
        ListIterator<SargInterval> targetIter = targetSeq.list.listIterator();
        if (!targetIter.hasNext()) {
            return;
        }
        ListIterator<SargInterval> sourceIter = sourceSeq.list.listIterator();
        if (!sourceIter.hasNext()) {
            targetSeq.list.clear();
            return;
        }
        SargInterval target = targetIter.next();
        SargInterval source = sourceIter.next();
        while (true) {
            int c;
            if (source.getUpperBound().compareTo(target.getLowerBound()) < 0) {
                if (!sourceIter.hasNext()) break;
                source = sourceIter.next();
                continue;
            }
            if (target.getUpperBound().compareTo(source.getLowerBound()) < 0) {
                targetIter.remove();
                if (!targetIter.hasNext()) {
                    return;
                }
                target = targetIter.next();
                continue;
            }
            if (source.getLowerBound().compareTo(target.getLowerBound()) > 0) {
                target.setLower(source.getLowerBound().getCoordinate(), source.getLowerBound().getStrictness());
            }
            if ((c = source.getUpperBound().compareTo(target.getUpperBound())) < 0) {
                SargInterval newTarget = new SargInterval(this.factory, this.dataType);
                newTarget.setLower(source.getUpperBound().getCoordinate(), source.getUpperBound().getStrictnessComplement());
                if (target.getUpperBound().isFinite()) {
                    newTarget.setUpper(target.getUpperBound().getCoordinate(), target.getUpperBound().getStrictness());
                }
                target.setUpper(source.getUpperBound().getCoordinate(), source.getUpperBound().getStrictness());
                targetIter.add(newTarget);
                target = targetIter.previous();
                target = targetIter.next();
                if (!sourceIter.hasNext()) break;
                source = sourceIter.next();
                continue;
            }
            if (c == 0) {
                if (!targetIter.hasNext()) {
                    return;
                }
                target = targetIter.next();
                if (!sourceIter.hasNext()) break;
                source = sourceIter.next();
                continue;
            }
            assert (c > 0);
            if (!targetIter.hasNext()) {
                return;
            }
            target = targetIter.next();
        }
        while (true) {
            targetIter.remove();
            if (!targetIter.hasNext()) break;
            targetIter.next();
        }
    }

    @Override
    public SargIntervalSequence evaluateComplemented() {
        if (this.setOp == SargSetOperator.COMPLEMENT) {
            return this.children.get(0).evaluate();
        }
        ArrayList<SargIntervalSequence> list = new ArrayList<SargIntervalSequence>();
        for (SargExpr child : this.children) {
            SargIntervalSequence newSeq = child.evaluateComplemented();
            list.add(newSeq);
        }
        switch (this.setOp) {
            case INTERSECTION: {
                return this.evaluateUnion(list);
            }
            case UNION: {
                return this.evaluateIntersection(list);
            }
        }
        throw Util.newInternal(this.setOp.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntervalComparator
    implements Comparator<SargInterval> {
        public static final IntervalComparator INSTANCE = new IntervalComparator();

        private IntervalComparator() {
        }

        @Override
        public int compare(SargInterval i1, SargInterval i2) {
            int c = i1.getLowerBound().compareTo(i2.getLowerBound());
            if (c != 0) {
                return c;
            }
            return i1.getUpperBound().compareTo(i2.getUpperBound());
        }
    }
}

