/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.List;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexChecker
extends RexVisitorImpl<Boolean> {
    protected final boolean fail;
    protected final List<RelDataType> inputTypeList;
    protected int failCount;

    public RexChecker(RelDataType inputRowType, boolean fail) {
        this(RelOptUtil.getFieldTypeList(inputRowType), fail);
    }

    public RexChecker(List<RelDataType> inputTypeList, boolean fail) {
        super(true);
        this.inputTypeList = inputTypeList;
        this.fail = fail;
    }

    public int getFailureCount() {
        return this.failCount;
    }

    @Override
    public Boolean visitInputRef(RexInputRef ref) {
        int index = ref.getIndex();
        if (index < 0 || index >= this.inputTypeList.size()) {
            assert (!this.fail) : "RexInputRef index " + index + " out of range 0.." + (this.inputTypeList.size() - 1);
            ++this.failCount;
            return false;
        }
        if (!ref.getType().isStruct() && !RelOptUtil.eq("ref", ref.getType(), "input", this.inputTypeList.get(index), this.fail)) {
            assert (!this.fail);
            ++this.failCount;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitLocalRef(RexLocalRef ref) {
        assert (!this.fail) : "RexLocalRef illegal outside program";
        ++this.failCount;
        return false;
    }

    @Override
    public Boolean visitCall(RexCall call) {
        for (RexNode operand : call.getOperands()) {
            Boolean valid = operand.accept(this);
            if (valid == null || valid.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
        super.visitFieldAccess(fieldAccess);
        RelDataType refType = fieldAccess.getReferenceExpr().getType();
        assert (refType.isStruct());
        RelDataTypeField field = fieldAccess.getField();
        int index = field.getIndex();
        if (index < 0 || index > refType.getFieldList().size()) {
            assert (!this.fail);
            ++this.failCount;
            return false;
        }
        RelDataTypeField typeField = refType.getFieldList().get(index);
        if (!RelOptUtil.eq("type1", typeField.getType(), "type2", fieldAccess.getType(), this.fail)) {
            assert (!this.fail);
            ++this.failCount;
            return false;
        }
        return true;
    }

    public final boolean isValid(RexNode expr) {
        return expr.accept(this);
    }
}

