/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptListener;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.AbstractConverter;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.trace.EigenbaseTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelSet {
    private static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    final List<RelNode> rels = new ArrayList<RelNode>();
    final List<RelNode> parents = new ArrayList<RelNode>();
    final List<RelSubset> subsets = new ArrayList<RelSubset>();
    final List<AbstractConverter> abstractConverters = new ArrayList<AbstractConverter>();
    RelSet equivalentSet;
    RelNode rel;
    final Set<String> variablesPropagated;
    final Set<String> variablesUsed;
    final int id;
    boolean inMetadataQuery;

    RelSet(int id, Set<String> variablesPropagated, Set<String> variablesUsed) {
        this.id = id;
        this.variablesPropagated = variablesPropagated;
        this.variablesUsed = variablesUsed;
    }

    public List<RelNode> getParentRels() {
        return this.parents;
    }

    public List<RelNode> getRelsFromAllSubsets() {
        return this.rels;
    }

    public RelSubset getSubset(RelTraitSet traits) {
        for (RelSubset subset : this.subsets) {
            if (!subset.getTraitSet().equals(traits)) continue;
            return subset;
        }
        return null;
    }

    void obliterateRelNode(RelNode rel) {
        this.parents.remove(rel);
    }

    public RelSubset add(RelNode rel) {
        assert (this.equivalentSet == null) : "adding to a dead set";
        RelSubset subset = this.getOrCreateSubset(rel.getCluster(), rel.getTraitSet());
        subset.add(rel);
        return subset;
    }

    RelSubset getOrCreateSubset(RelOptCluster cluster, RelTraitSet traits) {
        RelSubset subset = this.getSubset(traits);
        if (subset == null) {
            AbstractConverter converter;
            subset = new RelSubset(cluster, this, traits);
            VolcanoPlanner planner = (VolcanoPlanner)cluster.getPlanner();
            for (RelSubset subset1 : this.subsets) {
                if (subset1.getConvention() == Convention.NONE) continue;
                converter = new AbstractConverter(cluster, subset, ConventionTraitDef.INSTANCE, subset1.getTraitSet());
                planner.register(converter, subset1);
            }
            this.subsets.add(subset);
            for (RelSubset subset1 : this.subsets) {
                if (subset1 == subset) continue;
                converter = new AbstractConverter(cluster, subset1, ConventionTraitDef.INSTANCE, traits);
                planner.register(converter, subset);
            }
            if (planner.listener != null) {
                this.postEquivalenceEvent(planner, subset);
            }
        }
        return subset;
    }

    private void postEquivalenceEvent(VolcanoPlanner planner, RelNode rel) {
        RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, "equivalence class " + this.id, false);
        planner.listener.relEquivalenceFound(event);
    }

    void addInternal(RelNode rel) {
        if (!this.rels.contains(rel)) {
            this.rels.add(rel);
            VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
            if (planner.listener != null) {
                this.postEquivalenceEvent(planner, rel);
            }
        }
        if (this.rel == null) {
            this.rel = rel;
        } else {
            assert (rel.getCorrelVariable() == null);
            String correl = this.rel.getCorrelVariable();
            if (correl != null) {
                rel.setCorrelVariable(correl);
            }
            RelOptUtil.verifyTypeEquivalence(this.rel, rel, this);
        }
    }

    void mergeWith(VolcanoPlanner planner, RelSet otherSet) {
        assert (this != otherSet);
        assert (this.equivalentSet == null);
        assert (otherSet.equivalentSet == null);
        LOGGER.finer("Merge set#" + otherSet.id + " into set#" + this.id);
        otherSet.equivalentSet = this;
        boolean existed = planner.allSets.remove(otherSet);
        assert (existed) : "merging with a dead otherSet";
        for (RelSubset otherSubset : otherSet.subsets) {
            planner.ruleQueue.subsetImportances.remove(otherSubset);
            RelSubset subset = this.getOrCreateSubset(otherSubset.getCluster(), otherSubset.getTraitSet());
            if (otherSubset.bestCost.isLt(subset.bestCost)) {
                subset.bestCost = otherSubset.bestCost;
                subset.best = otherSubset.best;
            }
            for (RelNode otherRel : otherSubset.getRels()) {
                planner.reregister(this, otherRel);
            }
        }
        assert (this.equivalentSet == null);
        ImmutableList previousParents = ImmutableList.copyOf(otherSet.getParentRels());
        for (RelNode parentRel : previousParents) {
            planner.rename(parentRel);
        }
        if (this.equivalentSet != null) {
            return;
        }
        HashSet<RelSubset> activeSet = new HashSet<RelSubset>();
        for (RelNode parentRel : this.getParentRels()) {
            RelSubset parentSubset = planner.getSubset(parentRel);
            parentSubset.propagateCostImprovements(planner, parentRel, activeSet);
        }
        assert (activeSet.isEmpty());
        assert (this.equivalentSet == null);
        for (RelNode rel : this.rels) {
            assert (planner.getSet(rel) == this);
            planner.fireRules(rel, true);
        }
    }
}

