/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.trace.EigenbaseTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelOptRuleCall {
    protected static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    private static int nextId = 0;
    public final int id = nextId++;
    private final RelOptRuleOperand operand0;
    private final Map<RelNode, List<RelNode>> nodeChildren;
    public final RelOptRule rule;
    public final RelNode[] rels;
    private final RelOptPlanner planner;
    private final List<RelNode> parents;

    protected RelOptRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeChildren, List<RelNode> parents) {
        this.planner = planner;
        this.operand0 = operand;
        this.nodeChildren = nodeChildren;
        this.rule = operand.getRule();
        this.rels = rels;
        this.parents = parents;
        assert (rels.length == this.rule.operands.size());
    }

    protected RelOptRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeChildren) {
        this(planner, operand, rels, nodeChildren, null);
    }

    public RelOptRuleOperand getOperand0() {
        return this.operand0;
    }

    public RelOptRule getRule() {
        return this.rule;
    }

    public RelNode[] getRels() {
        return this.rels;
    }

    public List<RelNode> getRelList() {
        return ImmutableList.copyOf((Object[])this.rels);
    }

    public <T extends RelNode> T rel(int ordinal) {
        return (T)this.rels[ordinal];
    }

    public List<RelNode> getChildRels(RelNode rel) {
        return this.nodeChildren.get(rel);
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public List<RelNode> getParents() {
        return this.parents;
    }

    public abstract void transformTo(RelNode var1, Map<RelNode, RelNode> var2);

    public final void transformTo(RelNode rel) {
        this.transformTo(rel, (Map<RelNode, RelNode>)ImmutableMap.of());
    }
}

