/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwapJoinRule
extends RelOptRule {
    public static final SwapJoinRule INSTANCE = new SwapJoinRule();
    private final RelFactories.ProjectFactory projectFactory;

    private SwapJoinRule() {
        this(JoinRel.class, RelFactories.DEFAULT_PROJECT_FACTORY);
    }

    public SwapJoinRule(Class<? extends JoinRelBase> clazz, RelFactories.ProjectFactory projectFactory) {
        super(SwapJoinRule.operand(clazz, SwapJoinRule.any()));
        this.projectFactory = projectFactory;
    }

    public static RelNode swap(JoinRelBase join) {
        return SwapJoinRule.swap(join, false);
    }

    public static RelNode swap(JoinRelBase join, boolean swapOuterJoins) {
        JoinRelType joinType = join.getJoinType();
        if (!swapOuterJoins && joinType != JoinRelType.INNER) {
            return null;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelDataType leftRowType = join.getLeft().getRowType();
        RelDataType rightRowType = join.getRight().getRowType();
        VariableReplacer variableReplacer = new VariableReplacer(rexBuilder, leftRowType, rightRowType);
        RexNode oldCondition = join.getCondition();
        RexNode condition = variableReplacer.go(oldCondition);
        JoinRelBase newJoin = join.copy(join.getTraitSet(), condition, join.getRight(), join.getLeft(), joinType.swap(), join.isSemiJoinDone());
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, true);
        return CalcRel.createProject(newJoin, exps, join.getRowType().getFieldNames(), true);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinRelBase join = (JoinRelBase)call.rel(0);
        if (!join.getSystemFieldList().isEmpty()) {
            return;
        }
        RelNode swapped = SwapJoinRule.swap(join);
        if (swapped == null) {
            return;
        }
        JoinRelBase newJoin = swapped instanceof JoinRelBase ? (JoinRelBase)swapped : (JoinRelBase)swapped.getInput(0);
        call.transformTo(swapped);
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, false);
        RelNode project = this.projectFactory.createProject(swapped, exps, newJoin.getRowType().getFieldNames());
        RelNode rel = call.getPlanner().ensureRegistered(project, newJoin);
        Util.discard(rel);
    }

    private static class VariableReplacer {
        private final RexBuilder rexBuilder;
        private final List<RelDataTypeField> leftFields;
        private final List<RelDataTypeField> rightFields;

        VariableReplacer(RexBuilder rexBuilder, RelDataType leftType, RelDataType rightType) {
            this.rexBuilder = rexBuilder;
            this.leftFields = leftType.getFieldList();
            this.rightFields = rightType.getFieldList();
        }

        public RexNode go(RexNode rex) {
            if (rex instanceof RexCall) {
                ImmutableList.Builder builder = ImmutableList.builder();
                RexCall call = (RexCall)rex;
                for (RexNode operand : call.operands) {
                    builder.add((Object)this.go(operand));
                }
                return call.clone(call.getType(), (List<RexNode>)builder.build());
            }
            if (rex instanceof RexInputRef) {
                RexInputRef var = (RexInputRef)rex;
                int index = var.getIndex();
                if (index < this.leftFields.size()) {
                    return this.rexBuilder.makeInputRef(this.leftFields.get(index).getType(), this.rightFields.size() + index);
                }
                if ((index -= this.leftFields.size()) < this.rightFields.size()) {
                    return this.rexBuilder.makeInputRef(this.rightFields.get(index).getType(), index);
                }
                throw Util.newInternal("Bad field offset: index=" + var.getIndex() + ", leftFieldCount=" + this.leftFields.size() + ", rightFieldCount=" + this.rightFields.size());
            }
            return rex;
        }
    }
}

