/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.rules.ReduceExpressionsRule;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.Util;

public abstract class ReduceValuesRule
extends RelOptRule {
    private static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    public static final ReduceValuesRule FILTER_INSTANCE = new ReduceValuesRule(ReduceValuesRule.operand(FilterRel.class, ReduceValuesRule.operand(ValuesRel.class, ReduceValuesRule.none()), new RelOptRuleOperand[0]), "ReduceValuesRule[Filter"){

        public void onMatch(RelOptRuleCall call) {
            FilterRel filter = (FilterRel)call.rel(0);
            ValuesRel values = (ValuesRel)call.rel(1);
            this.apply(call, null, filter, values);
        }
    };
    public static final ReduceValuesRule PROJECT_INSTANCE = new ReduceValuesRule(ReduceValuesRule.operand(ProjectRel.class, ReduceValuesRule.operand(ValuesRel.class, ReduceValuesRule.none()), new RelOptRuleOperand[0]), "ReduceValuesRule[Project]"){

        public void onMatch(RelOptRuleCall call) {
            ProjectRel project = (ProjectRel)call.rel(0);
            ValuesRel values = (ValuesRel)call.rel(1);
            this.apply(call, project, null, values);
        }
    };
    public static final ReduceValuesRule PROJECT_FILTER_INSTANCE = new ReduceValuesRule(ReduceValuesRule.operand(ProjectRel.class, ReduceValuesRule.operand(FilterRel.class, ReduceValuesRule.operand(ValuesRel.class, ReduceValuesRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ReduceValuesRule[Project+Filter]"){

        public void onMatch(RelOptRuleCall call) {
            ProjectRel project = (ProjectRel)call.rel(0);
            FilterRel filter = (FilterRel)call.rel(1);
            ValuesRel values = (ValuesRel)call.rel(2);
            this.apply(call, project, filter, values);
        }
    };

    private ReduceValuesRule(RelOptRuleOperand operand, String desc) {
        super(operand, desc);
        Util.discard(LOGGER);
    }

    protected void apply(RelOptRuleCall call, ProjectRel project, FilterRel filter, ValuesRel values) {
        assert (values != null);
        assert (filter != null || project != null);
        RexNode conditionExpr = filter == null ? null : filter.getCondition();
        List<RexNode> projectExprs = project == null ? null : project.getProjects();
        RexBuilder rexBuilder = values.getCluster().getRexBuilder();
        ArrayList<RexNode> reducibleExps = new ArrayList<RexNode>();
        MyRexShuttle shuttle = new MyRexShuttle();
        for (List<RexLiteral> literalList : values.getTuples()) {
            shuttle.literalList = literalList;
            if (conditionExpr != null) {
                RexNode c = conditionExpr.accept(shuttle);
                reducibleExps.add(c);
            }
            if (projectExprs == null) continue;
            int k = -1;
            for (RexNode projectExpr : projectExprs) {
                ++k;
                RexNode e = projectExpr.accept(shuttle);
                if (RexLiteral.isNullLiteral(e)) {
                    e = rexBuilder.makeAbstractCast(project.getRowType().getFieldList().get(k).getType(), e);
                }
                reducibleExps.add(e);
            }
        }
        int fieldsPerRow = (conditionExpr == null ? 0 : 1) + (projectExprs == null ? 0 : projectExprs.size());
        assert (fieldsPerRow > 0);
        assert (reducibleExps.size() == values.getTuples().size() * fieldsPerRow);
        ReduceExpressionsRule.reduceExpressions(values, reducibleExps);
        int changeCount = 0;
        ArrayList<List<RexLiteral>> tupleList = new ArrayList<List<RexLiteral>>();
        for (int row = 0; row < values.getTuples().size(); ++row) {
            RexNode reducedValue;
            int i = 0;
            if (conditionExpr != null) {
                reducedValue = (RexNode)reducibleExps.get(row * fieldsPerRow + i);
                ++i;
                if (!reducedValue.isAlwaysTrue()) {
                    ++changeCount;
                    continue;
                }
            }
            List<Object> valuesList = new ArrayList();
            if (projectExprs != null) {
                ++changeCount;
                while (i < fieldsPerRow) {
                    reducedValue = (RexNode)reducibleExps.get(row * fieldsPerRow + i);
                    if (reducedValue instanceof RexLiteral) {
                        valuesList.add((RexLiteral)reducedValue);
                    } else if (RexUtil.isNullLiteral(reducedValue, true)) {
                        valuesList.add(rexBuilder.constantNull());
                    } else {
                        return;
                    }
                    ++i;
                }
            } else {
                valuesList = values.getTuples().get(row);
            }
            tupleList.add(valuesList);
        }
        if (changeCount > 0) {
            RelDataType rowType = projectExprs != null ? project.getRowType() : values.getRowType();
            AbstractRelNode newRel = tupleList.isEmpty() ? new EmptyRel(values.getCluster(), rowType) : new ValuesRel(values.getCluster(), rowType, tupleList);
            call.transformTo(newRel);
        } else {
            call.transformTo(values);
        }
        if (filter != null) {
            call.getPlanner().setImportance(filter, 0.0);
        }
    }

    private static class MyRexShuttle
    extends RexShuttle {
        private List<RexLiteral> literalList;

        private MyRexShuttle() {
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.literalList.get(inputRef.getIndex());
        }
    }
}

