/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Pair;

public class PushSemiJoinPastProjectRule
extends RelOptRule {
    public static final PushSemiJoinPastProjectRule INSTANCE = new PushSemiJoinPastProjectRule();

    private PushSemiJoinPastProjectRule() {
        super(PushSemiJoinPastProjectRule.operand(SemiJoinRel.class, PushSemiJoinPastProjectRule.some(PushSemiJoinPastProjectRule.operand(ProjectRel.class, PushSemiJoinPastProjectRule.any()), new RelOptRuleOperand[0])));
    }

    public void onMatch(RelOptRuleCall call) {
        SemiJoinRel semiJoin = (SemiJoinRel)call.rel(0);
        ProjectRel project = (ProjectRel)call.rel(1);
        ArrayList<Integer> newLeftKeys = new ArrayList<Integer>();
        List<Integer> leftKeys = semiJoin.getLeftKeys();
        List<RexNode> projExprs = project.getProjects();
        for (int leftKey : leftKeys) {
            RexInputRef inputRef = (RexInputRef)projExprs.get(leftKey);
            newLeftKeys.add(inputRef.getIndex());
        }
        RexNode newCondition = this.adjustCondition(project, semiJoin);
        SemiJoinRel newSemiJoin = new SemiJoinRel(semiJoin.getCluster(), project.getChild(), semiJoin.getRight(), newCondition, newLeftKeys, semiJoin.getRightKeys());
        RelNode newProject = CalcRel.createProject((RelNode)newSemiJoin, projExprs, project.getRowType().getFieldNames());
        call.transformTo(newProject);
    }

    private RexNode adjustCondition(ProjectRel project, SemiJoinRel semiJoin) {
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelNode rightChild = semiJoin.getRight();
        RelDataType bottomInputRowType = JoinRelBase.deriveJoinRowType(project.getChild().getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, semiJoin.getSystemFieldList());
        RexProgramBuilder bottomProgramBuilder = new RexProgramBuilder(bottomInputRowType, rexBuilder);
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            bottomProgramBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        int nLeftFields = project.getChild().getRowType().getFieldCount();
        List<RelDataTypeField> rightFields = rightChild.getRowType().getFieldList();
        int nRightFields = rightFields.size();
        for (int i = 0; i < nRightFields; ++i) {
            RelDataTypeField field = rightFields.get(i);
            RexInputRef inputRef = rexBuilder.makeInputRef(field.getType(), i + nLeftFields);
            bottomProgramBuilder.addProject(inputRef, field.getName());
        }
        RexProgram bottomProgram = bottomProgramBuilder.getProgram();
        RelDataType topInputRowType = JoinRelBase.deriveJoinRowType(project.getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, semiJoin.getSystemFieldList());
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(topInputRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(semiJoin.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }
}

