/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableFunctionRel;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;

public class PushFilterPastTableFunctionRule
extends RelOptRule {
    public static final PushFilterPastTableFunctionRule INSTANCE = new PushFilterPastTableFunctionRule();

    private PushFilterPastTableFunctionRule() {
        super(PushFilterPastTableFunctionRule.operand(FilterRel.class, PushFilterPastTableFunctionRule.operand(TableFunctionRel.class, PushFilterPastTableFunctionRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel filterRel = (FilterRel)call.rel(0);
        TableFunctionRel funcRel = (TableFunctionRel)call.rel(1);
        Set<RelColumnMapping> columnMappings = funcRel.getColumnMappings();
        if (columnMappings == null || columnMappings.isEmpty()) {
            return;
        }
        List<RelNode> funcInputs = funcRel.getInputs();
        if (funcInputs.size() != 1) {
            return;
        }
        if (funcRel.getRowType().getFieldCount() != funcInputs.get(0).getRowType().getFieldCount()) {
            return;
        }
        for (RelColumnMapping mapping : columnMappings) {
            if (mapping.iInputColumn != mapping.iOutputColumn) {
                return;
            }
            if (!mapping.derived) continue;
            return;
        }
        ArrayList<RelNode> newFuncInputs = new ArrayList<RelNode>();
        RelOptCluster cluster = funcRel.getCluster();
        RexNode condition = filterRel.getCondition();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = funcRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        for (RelNode funcInput : funcInputs) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, funcInput.getRowType().getFieldList(), adjustments));
            newFuncInputs.add(new FilterRel(cluster, funcInput, newCondition));
        }
        TableFunctionRel newFuncRel = new TableFunctionRel(cluster, newFuncInputs, funcRel.getCall(), funcRel.getElementType(), funcRel.getRowType(), columnMappings);
        call.transformTo(newFuncRel);
    }
}

