/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.Collections;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Pair;

public class MergeProjectOntoCalcRule
extends RelOptRule {
    public static final MergeProjectOntoCalcRule INSTANCE = new MergeProjectOntoCalcRule();

    private MergeProjectOntoCalcRule() {
        super(MergeProjectOntoCalcRule.operand(ProjectRel.class, MergeProjectOntoCalcRule.operand(CalcRel.class, MergeProjectOntoCalcRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectRel project = (ProjectRel)call.rel(0);
        CalcRel calc = (CalcRel)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        RexProgram program = RexProgram.create(calc.getRowType(), project.getProjects(), null, project.getRowType(), cluster.getRexBuilder());
        if (RexOver.containsOver(program)) {
            CalcRel projectAsCalc = new CalcRel(cluster, project.getTraitSet(), calc, project.getRowType(), program, Collections.<RelCollation>emptyList());
            call.transformTo(projectAsCalc);
            return;
        }
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        for (Pair<RexNode, String> field : project.getNamedProjects()) {
            progBuilder.addProject((RexNode)field.left, (String)field.right);
        }
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        CalcRel newCalc = new CalcRel(cluster, project.getTraitSet(), calc.getChild(), project.getRowType(), mergedProgram, Collections.<RelCollation>emptyList());
        call.transformTo(newCalc);
    }
}

