/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.Collections;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;

public class MergeFilterOntoCalcRule
extends RelOptRule {
    public static final MergeFilterOntoCalcRule INSTANCE = new MergeFilterOntoCalcRule();

    private MergeFilterOntoCalcRule() {
        super(MergeFilterOntoCalcRule.operand(FilterRelBase.class, MergeFilterOntoCalcRule.operand(CalcRel.class, MergeFilterOntoCalcRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel filter = (FilterRel)call.rel(0);
        CalcRel calc = (CalcRel)call.rel(1);
        if (calc.getProgram().containsAggs()) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        progBuilder.addIdentity();
        progBuilder.addCondition(filter.getCondition());
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        CalcRel newCalc = new CalcRel(calc.getCluster(), calc.getTraitSet(), calc.getChild(), filter.getRowType(), mergedProgram, Collections.<RelCollation>emptyList());
        call.transformTo(newCalc);
    }
}

