/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;

public class MergeCalcRule
extends RelOptRule {
    public static final MergeCalcRule INSTANCE = new MergeCalcRule();

    private MergeCalcRule() {
        super(MergeCalcRule.operand(CalcRelBase.class, MergeCalcRule.operand(CalcRelBase.class, MergeCalcRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        CalcRelBase topCalc = (CalcRelBase)call.rel(0);
        CalcRelBase bottomCalc = (CalcRelBase)call.rel(1);
        RexProgram topProgram = topCalc.getProgram();
        if (RexOver.containsOver(topProgram)) {
            return;
        }
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topCalc.getProgram(), bottomCalc.getProgram(), topCalc.getCluster().getRexBuilder());
        assert (mergedProgram.getOutputRowType() == topProgram.getOutputRowType());
        CalcRelBase newCalc = topCalc.copy(topCalc.getTraitSet(), bottomCalc.getChild(), mergedProgram, topCalc.getCollationList());
        if (newCalc.getDigest().equals(bottomCalc.getDigest())) {
            call.getPlanner().setImportance(topCalc, 0.0);
        }
        call.transformTo(newCalc);
    }
}

