/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtractJoinFilterRule
extends RelOptRule {
    public static final ExtractJoinFilterRule INSTANCE = new ExtractJoinFilterRule(JoinRel.class);

    public ExtractJoinFilterRule(Class<? extends JoinRelBase> clazz) {
        super(ExtractJoinFilterRule.operand(clazz, ExtractJoinFilterRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinRelBase join = (JoinRelBase)call.rel(0);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        if (!join.getSystemFieldList().isEmpty()) {
            return;
        }
        JoinRelBase cartesianJoinRel = join.copy(join.getTraitSet(), join.getCluster().getRexBuilder().makeLiteral(true), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        RelNode filterRel = CalcRel.createFilter(cartesianJoinRel, join.getCondition());
        call.transformTo(filterRel);
    }
}

