/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRedundantSemiJoinRule
extends RelOptRule {
    public static final AddRedundantSemiJoinRule INSTANCE = new AddRedundantSemiJoinRule(JoinRel.class);

    private AddRedundantSemiJoinRule(Class<? extends JoinRelBase> clazz) {
        super(AddRedundantSemiJoinRule.operand(clazz, AddRedundantSemiJoinRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinRelBase origJoinRel = (JoinRelBase)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), leftKeys, rightKeys);
        if (leftKeys.size() == 0) {
            return;
        }
        SemiJoinRel semiJoin = new SemiJoinRel(origJoinRel.getCluster(), origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), leftKeys, rightKeys);
        JoinRelBase newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }
}

