/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.util14.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelMdUtil {
    public static final SqlFunction ARTIFICIAL_SELECTIVITY_FUNC = new SqlFunction("ARTIFICIAL_SELECTIVITY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, OperandTypes.NUMERIC, SqlFunctionCategory.SYSTEM);

    private RelMdUtil() {
    }

    public static RexNode makeSemiJoinSelectivityRexNode(SemiJoinRel rel) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        double selectivity = RelMdUtil.computeSemiJoinSelectivity(rel.getLeft(), rel.getRight(), rel);
        RexLiteral selec = rexBuilder.makeApproxLiteral(new BigDecimal(selectivity));
        return rexBuilder.makeCall((SqlOperator)ARTIFICIAL_SELECTIVITY_FUNC, selec);
    }

    public static double getSelectivityValue(RexNode artificialSelecFuncNode) {
        assert (artificialSelecFuncNode instanceof RexCall);
        RexCall call = (RexCall)artificialSelecFuncNode;
        assert (call.getOperator() == ARTIFICIAL_SELECTIVITY_FUNC);
        RexNode operand = call.getOperands().get(0);
        BigDecimal bd = (BigDecimal)((RexLiteral)operand).getValue();
        return bd.doubleValue();
    }

    public static double computeSemiJoinSelectivity(SemiJoinRel rel) {
        return RelMdUtil.computeSemiJoinSelectivity(rel.getLeft(), rel.getRight(), rel.getLeftKeys(), rel.getRightKeys());
    }

    public static double computeSemiJoinSelectivity(RelNode factRel, RelNode dimRel, SemiJoinRel rel) {
        return RelMdUtil.computeSemiJoinSelectivity(factRel, dimRel, rel.getLeftKeys(), rel.getRightKeys());
    }

    public static double computeSemiJoinSelectivity(RelNode factRel, RelNode dimRel, List<Integer> factKeyList, List<Integer> dimKeyList) {
        Double selectivity;
        Double dimCard;
        BitSet factKeys = new BitSet();
        for (int factCol : factKeyList) {
            factKeys.set(factCol);
        }
        BitSet dimKeys = new BitSet();
        for (int dimCol : dimKeyList) {
            dimKeys.set(dimCol);
        }
        Double factPop = RelMetadataQuery.getPopulationSize(factRel, factKeys);
        if (factPop == null) {
            factPop = RelMetadataQuery.getPopulationSize(dimRel, dimKeys);
        }
        if ((dimCard = RelMetadataQuery.getDistinctRowCount(dimRel, dimKeys, null)) != null && factPop != null) {
            if (factPop < 1.0) {
                factPop = 1.0;
            }
            selectivity = dimCard / factPop;
        } else {
            selectivity = RelMetadataQuery.getPercentageOriginalRows(dimRel);
        }
        if (selectivity == null) {
            selectivity = Math.pow(0.1, dimKeys.cardinality());
        } else if (selectivity > 1.0) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    public static boolean areColumnsDefinitelyUnique(RelNode rel, BitSet colMask) {
        Boolean b = RelMetadataQuery.areColumnsUnique(rel, colMask, false);
        return b != null && b != false;
    }

    public static Boolean areColumnsUnique(RelNode rel, List<RexInputRef> columnRefs) {
        BitSet colMask = new BitSet();
        for (RexInputRef columnRef : columnRefs) {
            colMask.set(columnRef.getIndex());
        }
        return RelMetadataQuery.areColumnsUnique(rel, colMask);
    }

    public static boolean areColumnsDefinitelyUnique(RelNode rel, List<RexInputRef> columnRefs) {
        Boolean b = RelMdUtil.areColumnsUnique(rel, columnRefs);
        return b != null && b != false;
    }

    public static boolean areColumnsDefinitelyUniqueWhenNullsFiltered(RelNode rel, BitSet colMask) {
        Boolean b = RelMetadataQuery.areColumnsUnique(rel, colMask, true);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Boolean areColumnsUniqueWhenNullsFiltered(RelNode rel, List<RexInputRef> columnRefs) {
        BitSet colMask = new BitSet();
        for (RexInputRef columnRef : columnRefs) {
            colMask.set(columnRef.getIndex());
        }
        return RelMetadataQuery.areColumnsUnique(rel, colMask, true);
    }

    public static boolean areColumnsDefinitelyUniqueWhenNullsFiltered(RelNode rel, List<RexInputRef> columnRefs) {
        Boolean b = RelMdUtil.areColumnsUniqueWhenNullsFiltered(rel, columnRefs);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static void setLeftRightBitmaps(BitSet groupKey, BitSet leftMask, BitSet rightMask, int nFieldsOnLeft) {
        for (int bit : BitSets.toIter(groupKey)) {
            if (bit < nFieldsOnLeft) {
                leftMask.set(bit);
                continue;
            }
            rightMask.set(bit - nFieldsOnLeft);
        }
    }

    public static Double numDistinctVals(Double domainSize, Double numSelected) {
        double res;
        if (domainSize == null || numSelected == null) {
            return null;
        }
        double dSize = RelMdUtil.capInfinity(domainSize);
        double numSel = RelMdUtil.capInfinity(numSelected);
        double d = res = dSize > 0.0 ? (1.0 - Math.exp(-1.0 * numSel / dSize)) * dSize : 0.0;
        if (res > dSize) {
            res = dSize;
        }
        if (res > numSel) {
            res = numSel;
        }
        if (res < 0.0) {
            res = 0.0;
        }
        return res;
    }

    public static double capInfinity(Double d) {
        return d.isInfinite() ? Double.MAX_VALUE : d;
    }

    public static double guessSelectivity(RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate, false);
    }

    public static double guessSelectivity(RexNode predicate, boolean artificialOnly) {
        double sel = 1.0;
        if (predicate == null || predicate.isAlwaysTrue()) {
            return sel;
        }
        double artificialSel = 1.0;
        for (RexNode pred : RelOptUtil.conjunctions(predicate)) {
            if (pred.getKind() == SqlKind.IS_NOT_NULL) {
                sel *= 0.9;
                continue;
            }
            if (pred instanceof RexCall && ((RexCall)pred).getOperator() == ARTIFICIAL_SELECTIVITY_FUNC) {
                artificialSel *= RelMdUtil.getSelectivityValue(pred);
                continue;
            }
            if (pred.isA(SqlKind.EQUALS)) {
                sel *= 0.15;
                continue;
            }
            if (pred.isA(SqlKind.COMPARISON)) {
                sel *= 0.5;
                continue;
            }
            sel *= 0.25;
        }
        if (artificialOnly) {
            return artificialSel;
        }
        return sel * artificialSel;
    }

    public static RexNode findEquiJoinCols(RelNode leftChild, RelNode rightChild, RexNode predicate, BitSet leftJoinCols, BitSet rightJoinCols) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode nonEquiJoin = RelOptUtil.splitJoinCondition(leftChild, rightChild, predicate, leftKeys, rightKeys);
        assert (nonEquiJoin != null);
        for (int i = 0; i < leftKeys.size(); ++i) {
            leftJoinCols.set((Integer)leftKeys.get(i));
            rightJoinCols.set((Integer)rightKeys.get(i));
        }
        return nonEquiJoin;
    }

    public static RexNode unionPreds(RexBuilder rexBuilder, RexNode pred1, RexNode pred2) {
        ArrayList<RexNode> unionList = new ArrayList<RexNode>();
        HashSet<String> strings = new HashSet<String>();
        for (RexNode rex : RelOptUtil.conjunctions(pred1)) {
            if (!strings.add(rex.toString())) continue;
            unionList.add(rex);
        }
        for (RexNode rex2 : RelOptUtil.conjunctions(pred2)) {
            if (!strings.add(rex2.toString())) continue;
            unionList.add(rex2);
        }
        return RexUtil.composeConjunction(rexBuilder, unionList, true);
    }

    public static RexNode minusPreds(RexBuilder rexBuilder, RexNode pred1, RexNode pred2) {
        List<RexNode> list1 = RelOptUtil.conjunctions(pred1);
        List<RexNode> list2 = RelOptUtil.conjunctions(pred2);
        ArrayList<RexNode> minusList = new ArrayList<RexNode>();
        for (RexNode rex1 : list1) {
            boolean add = true;
            for (RexNode rex2 : list2) {
                if (rex2.toString().compareTo(rex1.toString()) != 0) continue;
                add = false;
                break;
            }
            if (!add) continue;
            minusList.add(rex1);
        }
        return RexUtil.composeConjunction(rexBuilder, minusList, true);
    }

    public static void setAggChildKeys(BitSet groupKey, AggregateRelBase aggRel, BitSet childKey) {
        List<AggregateCall> aggCalls = aggRel.getAggCallList();
        for (int bit : BitSets.toIter(groupKey)) {
            if (bit < aggRel.getGroupCount()) {
                childKey.set(bit);
                continue;
            }
            AggregateCall agg = aggCalls.get(bit - aggRel.getGroupCount());
            for (Integer arg : agg.getArgList()) {
                childKey.set(arg);
            }
        }
    }

    public static void splitCols(List<RexNode> projExprs, BitSet groupKey, BitSet baseCols, BitSet projCols) {
        for (int bit : BitSets.toIter(groupKey)) {
            RexNode e = projExprs.get(bit);
            if (e instanceof RexInputRef) {
                baseCols.set(((RexInputRef)e).getIndex());
                continue;
            }
            projCols.set(bit);
        }
    }

    public static Double cardOfProjExpr(ProjectRelBase rel, RexNode expr) {
        return expr.accept(new CardOfProjExpr(rel));
    }

    public static Double getJoinPopulationSize(RelNode joinRel, BitSet groupKey) {
        BitSet leftMask = new BitSet();
        BitSet rightMask = new BitSet();
        RelNode left = joinRel.getInputs().get(0);
        RelNode right = joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps(groupKey, leftMask, rightMask, left.getRowType().getFieldCount());
        Double population = NumberUtil.multiply(RelMetadataQuery.getPopulationSize(left, leftMask), RelMetadataQuery.getPopulationSize(right, rightMask));
        return RelMdUtil.numDistinctVals(population, RelMetadataQuery.getRowCount(joinRel));
    }

    public static Double getJoinDistinctRowCount(RelNode joinRel, JoinRelType joinType, BitSet groupKey, RexNode predicate, boolean useMaxNdv) {
        BitSet leftMask = new BitSet();
        BitSet rightMask = new BitSet();
        RelNode left = joinRel.getInputs().get(0);
        RelNode right = joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps(groupKey, leftMask, rightMask, left.getRowType().getFieldCount());
        RexNode leftPred = null;
        RexNode rightPred = null;
        if (predicate != null) {
            ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
            ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
            ArrayList<RexNode> joinFilters = new ArrayList<RexNode>();
            List<RexNode> predList = RelOptUtil.conjunctions(predicate);
            RelOptUtil.classifyFilters(joinRel, predList, joinType == JoinRelType.INNER, !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters);
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            leftPred = RexUtil.composeConjunction(rexBuilder, leftFilters, true);
            rightPred = RexUtil.composeConjunction(rexBuilder, rightFilters, true);
        }
        Double distRowCount = useMaxNdv ? Double.valueOf(Math.max(RelMetadataQuery.getDistinctRowCount(left, leftMask, leftPred), RelMetadataQuery.getDistinctRowCount(right, rightMask, rightPred))) : NumberUtil.multiply(RelMetadataQuery.getDistinctRowCount(left, leftMask, leftPred), RelMetadataQuery.getDistinctRowCount(right, rightMask, rightPred));
        return RelMdUtil.numDistinctVals(distRowCount, RelMetadataQuery.getRowCount(joinRel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CardOfProjExpr
    extends RexVisitorImpl<Double> {
        private ProjectRelBase rel;

        public CardOfProjExpr(ProjectRelBase rel) {
            super(true);
            this.rel = rel;
        }

        @Override
        public Double visitInputRef(RexInputRef var) {
            int index = var.getIndex();
            BitSet col = new BitSet(index);
            col.set(index);
            Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(this.rel.getChild(), col, null);
            if (distinctRowCount == null) {
                return null;
            }
            return RelMdUtil.numDistinctVals(distinctRowCount, RelMetadataQuery.getRowCount(this.rel));
        }

        @Override
        public Double visitLiteral(RexLiteral literal) {
            return RelMdUtil.numDistinctVals(1.0, RelMetadataQuery.getRowCount(this.rel));
        }

        @Override
        public Double visitCall(RexCall call) {
            Double distinctRowCount;
            Double rowCount = RelMetadataQuery.getRowCount(this.rel);
            if (call.isA(SqlKind.MINUS_PREFIX)) {
                distinctRowCount = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0));
            } else if (call.isA((Collection<SqlKind>)ImmutableList.of((Object)((Object)SqlKind.PLUS), (Object)((Object)SqlKind.MINUS)))) {
                Double card0 = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0));
                if (card0 == null) {
                    return null;
                }
                Double card1 = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(1));
                if (card1 == null) {
                    return null;
                }
                distinctRowCount = Math.max(card0, card1);
            } else {
                distinctRowCount = call.isA((Collection<SqlKind>)ImmutableList.of((Object)((Object)SqlKind.TIMES), (Object)((Object)SqlKind.DIVIDE))) ? NumberUtil.multiply(RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0)), RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(1))) : (call.getOperands().size() == 1 ? RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0)) : Double.valueOf(rowCount / 10.0));
            }
            return RelMdUtil.numDistinctVals(distinctRowCount, rowCount);
        }
    }
}

