/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.BitSet;
import net.hydromatic.optiq.BuiltinMethod;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util14.NumberUtil;

public class RelMdRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.ROW_COUNT.method, new RelMdRowCount());

    public Double getRowCount(UnionRelBase rel) {
        double nRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = RelMetadataQuery.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            nRows += partialRowCount.doubleValue();
        }
        return nRows;
    }

    public Double getRowCount(FilterRelBase rel) {
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getChild(), rel.getCondition()), RelMetadataQuery.getRowCount(rel.getChild()));
    }

    public Double getRowCount(ProjectRelBase rel) {
        return RelMetadataQuery.getRowCount(rel.getChild());
    }

    public Double getRowCount(SortRel rel) {
        return RelMetadataQuery.getRowCount(rel.getChild());
    }

    public Double getRowCount(SemiJoinRel rel) {
        RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getLeft(), semiJoinSelectivity), RelMetadataQuery.getRowCount(rel.getLeft()));
    }

    public Double getRowCount(AggregateRelBase rel) {
        BitSet groupKey = new BitSet();
        for (int i = 0; i < rel.getGroupCount(); ++i) {
            groupKey.set(i);
        }
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getChild(), groupKey, null);
        if (distinctRowCount == null) {
            return RelMetadataQuery.getRowCount(rel.getChild()) / 10.0;
        }
        return distinctRowCount;
    }

    public Double getRowCount(RelNode rel) {
        return rel.getRows();
    }
}

