/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinRel
extends JoinRelBase {
    private final boolean semiJoinDone;
    private List<RelDataTypeField> systemFieldList;

    public JoinRel(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, left, right, condition, joinType, variablesStopped, false, Collections.emptyList());
    }

    public JoinRel(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone, List<RelDataTypeField> systemFieldList) {
        super(cluster, cluster.traitSetOf(Convention.NONE), left, right, condition, joinType, variablesStopped);
        assert (systemFieldList != null);
        this.semiJoinDone = semiJoinDone;
        this.systemFieldList = systemFieldList;
    }

    public JoinRel(RelInput input) {
        this(input.getCluster(), input.getInputs().get(0), input.getInputs().get(1), input.getExpression("condition"), input.getEnum("joinType", JoinRelType.class), (Set<String>)ImmutableSet.of(), false, (List<RelDataTypeField>)ImmutableList.of());
    }

    @Override
    public JoinRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new JoinRel(this.getCluster(), left, right, conditionExpr, joinType, (Set<String>)this.variablesStopped, semiJoinDone, this.systemFieldList);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("semiJoinDone", this.semiJoinDone, this.semiJoinDone);
    }

    @Override
    public boolean isSemiJoinDone() {
        return this.semiJoinDone;
    }

    @Override
    public List<RelDataTypeField> getSystemFieldList() {
        return this.systemFieldList;
    }
}

