/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayComparator
implements Comparator<Object[]> {
    private final Comparator[] comparators;

    public ArrayComparator(Comparator ... comparators) {
        this.comparators = comparators;
    }

    public ArrayComparator(boolean ... descendings) {
        this.comparators = ArrayComparator.comparators(descendings);
    }

    private static Comparator[] comparators(boolean[] descendings) {
        Comparator[] comparators = new Comparator[descendings.length];
        for (int i = 0; i < descendings.length; ++i) {
            boolean descending = descendings[i];
            comparators[i] = descending ? Collections.reverseOrder() : Ordering.natural();
        }
        return comparators;
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        for (int i = 0; i < this.comparators.length; ++i) {
            Comparator comparator = this.comparators[i];
            int c = comparator.compare(o1[i], o2[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

