/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.prepare.RelOptTableImpl;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.TableFunctionRelBase;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.relopt.RelOptMaterialization;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql2rel.SqlToRelConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptiqMaterializer
extends OptiqPrepareImpl.OptiqPreparingStmt {
    public OptiqMaterializer(OptiqPrepare.Context context, Prepare.CatalogReader catalogReader, OptiqSchema schema, RelOptPlanner planner) {
        super(context, catalogReader, catalogReader.getTypeFactory(), schema, EnumerableRel.Prefer.ANY, planner, EnumerableConvention.INSTANCE);
    }

    void populate(Prepare.Materialization materialization) {
        SqlNode node;
        SqlParser parser = SqlParser.create(materialization.sql);
        try {
            node = parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        SqlToRelConverter sqlToRelConverter2 = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader);
        materialization.queryRel = sqlToRelConverter2.convertQuery(node, true, true);
        this.useStar(this.schema, materialization);
        Prepare.PreparingTable table = this.catalogReader.getTable(materialization.materializedTable.path());
        materialization.tableRel = sqlToRelConverter2.toRel(table);
    }

    private void useStar(OptiqSchema schema, Prepare.Materialization materialization) {
        List<OptiqSchema.TableEntry> starTables = this.getStarTables(schema);
        if (starTables.isEmpty()) {
            return;
        }
        RelNode rel2 = RelOptMaterialization.toLeafJoinForm(materialization.queryRel);
        for (OptiqSchema.TableEntry starTable : starTables) {
            Table table = starTable.getTable();
            assert (table instanceof StarTable);
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, table.getRowType(this.typeFactory), starTable);
            RelNode rel3 = RelOptMaterialization.tryUseStar(rel2, starRelOptTable);
            if (rel3 == null) continue;
            materialization.materialize(rel3, starRelOptTable);
            System.out.println("Materialization " + materialization.materializedTable + " matched star table " + starTable + "; query after re-write: " + RelOptUtil.toString(materialization.queryRel));
            return;
        }
    }

    private List<OptiqSchema.TableEntry> getStarTables(OptiqSchema schema) {
        ArrayList<OptiqSchema.TableEntry> list = new ArrayList<OptiqSchema.TableEntry>();
        OptiqSchema matSchema = schema.root().getSubSchema("mat", true);
        if (matSchema != null) {
            for (OptiqSchema.TableEntry tis : matSchema.getTableEntries()) {
                if (tis.getTable().getJdbcTableType() != Schema.TableType.STAR) continue;
                list.add(tis);
            }
        }
        return list;
    }

    static class RelNullShuttle
    implements RelShuttle {
        RelNullShuttle() {
        }

        public RelNode visit(TableAccessRelBase scan) {
            return scan;
        }

        public RelNode visit(TableFunctionRelBase scan) {
            return scan;
        }

        public RelNode visit(ValuesRel values) {
            return values;
        }

        public RelNode visit(FilterRel filter) {
            return filter;
        }

        public RelNode visit(ProjectRel project) {
            return project;
        }

        public RelNode visit(JoinRel join) {
            return join;
        }

        public RelNode visit(UnionRel union) {
            return union;
        }

        public RelNode visit(IntersectRel intersect) {
            return intersect;
        }

        public RelNode visit(MinusRel minus) {
            return minus;
        }

        public RelNode visit(AggregateRel aggregate) {
            return aggregate;
        }

        public RelNode visit(SortRel sort) {
            return sort;
        }

        public RelNode visit(RelNode other) {
            return other;
        }
    }
}

