/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.jdbc.MetadataSchema;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.jdbc.SimpleOptiqRootSchema;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOptiqSchema
extends OptiqSchema {
    private Map<String, SimpleOptiqSchema> subSchemas = Maps.newHashMap();
    private Map<String, OptiqSchema.TableEntry> tables = Maps.newHashMap();

    public SimpleOptiqSchema(OptiqSchema parent, Schema schema, String name) {
        super(parent, schema, name);
    }

    @Override
    public OptiqSchema.TableEntry add(String tableName, Table table) {
        OptiqSchema.TableEntryImpl e = new OptiqSchema.TableEntryImpl(this, tableName, table);
        this.tables.put(tableName, e);
        return e;
    }

    @Override
    public OptiqSchema getSubSchema(String schemaName, boolean caseSensitive) {
        Schema s = this.schema.getSubSchema(schemaName);
        if (s != null) {
            return new SimpleOptiqSchema(this, s, schemaName);
        }
        return this.subSchemas.get(schemaName);
    }

    @Override
    public OptiqSchema add(String name, Schema schema) {
        SimpleOptiqSchema s = new SimpleOptiqSchema(this, schema, name);
        this.subSchemas.put(name, s);
        return s;
    }

    @Override
    public Pair<String, Table> getTable(String tableName, boolean caseSensitive) {
        OptiqSchema.TableEntry e;
        Table t = this.schema.getTable(tableName);
        if (t == null && (e = this.tables.get(tableName)) != null) {
            t = e.getTable();
        }
        if (t != null) {
            return new Pair<String, Table>(tableName, t);
        }
        return null;
    }

    @Override
    public Collection<OptiqSchema.TableEntry> getTableEntries() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return Sets.union(this.schema.getSubSchemaNames(), this.subSchemas.keySet());
    }

    @Override
    public Collection<OptiqSchema> getSubSchemas() {
        LinkedList schemas = Lists.newLinkedList();
        schemas.addAll(this.subSchemas.values());
        for (String name : this.schema.getSubSchemaNames()) {
            schemas.add(this.getSubSchema(name, true));
        }
        return schemas;
    }

    @Override
    public Set<String> getTableNames() {
        return Sets.union(this.schema.getTableNames(), this.tables.keySet());
    }

    @Override
    public Collection<Function> getFunctions(String name, boolean caseSensitive) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Set<String> getFunctionNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Map<String, Table> getTablesBasedOnNullaryFunctions() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Pair<String, Table> getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        return null;
    }

    @Override
    protected OptiqSchema.FunctionEntry add(String name, Function function) {
        throw new UnsupportedOperationException();
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        SimpleOptiqRootSchema rootSchema = new SimpleOptiqRootSchema(new OptiqConnectionImpl.RootSchema());
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema.plus();
    }
}

