/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter;

import java.util.Arrays;
import parquet.Preconditions;
import parquet.column.ColumnReader;
import parquet.filter.ColumnPredicates;
import parquet.filter.RecordFilter;
import parquet.filter.UnboundRecordFilter;

public final class ColumnRecordFilter
implements RecordFilter {
    private final ColumnReader filterOnColumn;
    private final ColumnPredicates.Predicate filterPredicate;

    public static final UnboundRecordFilter column(final String columnPath, final ColumnPredicates.Predicate predicate) {
        Preconditions.checkNotNull((Object)columnPath, (String)"columnPath");
        Preconditions.checkNotNull((Object)predicate, (String)"predicate");
        return new UnboundRecordFilter(){
            final String[] filterPath;
            {
                this.filterPath = string.split("\\.");
            }

            @Override
            public RecordFilter bind(Iterable<ColumnReader> readers) {
                for (ColumnReader reader : readers) {
                    if (!Arrays.equals(reader.getDescriptor().getPath(), this.filterPath)) continue;
                    return new ColumnRecordFilter(reader, predicate, null);
                }
                throw new IllegalArgumentException("Column " + columnPath + " does not exist.");
            }
        };
    }

    private ColumnRecordFilter(ColumnReader filterOnColumn, ColumnPredicates.Predicate filterPredicate) {
        this.filterOnColumn = filterOnColumn;
        this.filterPredicate = filterPredicate;
    }

    @Override
    public boolean isMatch() {
        return this.filterPredicate.apply(this.filterOnColumn);
    }

    /* synthetic */ ColumnRecordFilter(ColumnReader columnReader, ColumnPredicates.Predicate predicate, ColumnRecordFilter columnRecordFilter) {
        this(columnReader, predicate);
    }
}

