/*
 * Decompiled with CFR 0.152.
 */
package parquet.example.data;

import parquet.example.data.Group;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.Type;

public class GroupWriter {
    private final RecordConsumer recordConsumer;
    private final GroupType schema;

    public GroupWriter(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(Group group) {
        this.recordConsumer.startMessage();
        this.writeGroup(group, this.schema);
        this.recordConsumer.endMessage();
    }

    private void writeGroup(Group group, GroupType type) {
        int fieldCount = type.getFieldCount();
        int field = 0;
        while (field < fieldCount) {
            int valueCount = group.getFieldRepetitionCount(field);
            if (valueCount > 0) {
                Type fieldType = type.getType(field);
                String fieldName = fieldType.getName();
                this.recordConsumer.startField(fieldName, field);
                int index = 0;
                while (index < valueCount) {
                    if (fieldType.isPrimitive()) {
                        group.writeValue(field, index, this.recordConsumer);
                    } else {
                        this.recordConsumer.startGroup();
                        this.writeGroup(group.getGroup(field, index), fieldType.asGroupType());
                        this.recordConsumer.endGroup();
                    }
                    ++index;
                }
                this.recordConsumer.endField(fieldName, field);
            }
            ++field;
        }
    }
}

