/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.IOException;
import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.bitpacking.ByteBasedBitPackingEncoder;
import parquet.column.values.bitpacking.Packer;
import parquet.io.ParquetEncodingException;

public class ByteBitPackingValuesWriter
extends ValuesWriter {
    private final Packer packer;
    private final int bitWidth;
    private ByteBasedBitPackingEncoder encoder;

    public ByteBitPackingValuesWriter(int bound, Packer packer, ByteBufferAllocator a) {
        this.packer = packer;
        this.bitWidth = BytesUtils.getWidthFromMaxInt((int)bound);
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, packer);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.BIT_PACKED;
    }

    @Override
    public BytesInput getBytes() {
        try {
            return this.encoder.toBytes();
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public void reset() {
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, this.packer);
    }

    @Override
    public void close() {
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.encoder.memUsageString(prefix);
    }
}

