/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.impl;

import java.io.IOException;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnWriter;
import parquet.column.ParquetProperties;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageWriter;
import parquet.column.statistics.Statistics;
import parquet.column.values.ValuesWriter;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;

final class ColumnWriterImpl
implements ColumnWriter {
    private static final Log LOG = Log.getLog(ColumnWriterImpl.class);
    private static final boolean DEBUG = Log.DEBUG;
    private static final int INITIAL_COUNT_FOR_SIZE_CHECK = 100;
    private final ColumnDescriptor path;
    private final PageWriter pageWriter;
    private final long pageSizeThreshold;
    private ValuesWriter repetitionLevelColumn;
    private ValuesWriter definitionLevelColumn;
    private ValuesWriter dataColumn;
    private int valueCount;
    private int valueCountForNextSizeCheck;
    private Statistics statistics;

    public ColumnWriterImpl(ColumnDescriptor path, PageWriter pageWriter, int pageSizeThreshold, int initialSizePerCol, int dictionaryPageSizeThreshold, boolean enableDictionary, ParquetProperties.WriterVersion writerVersion) {
        this.path = path;
        this.pageWriter = pageWriter;
        this.pageSizeThreshold = pageSizeThreshold;
        this.valueCountForNextSizeCheck = 100;
        this.resetStatistics();
        ParquetProperties parquetProps = new ParquetProperties(dictionaryPageSizeThreshold, writerVersion, enableDictionary, pageWriter.getAllocator());
        this.repetitionLevelColumn = ParquetProperties.getColumnDescriptorValuesWriter(path.getMaxRepetitionLevel(), initialSizePerCol, pageWriter.getAllocator());
        this.definitionLevelColumn = ParquetProperties.getColumnDescriptorValuesWriter(path.getMaxDefinitionLevel(), initialSizePerCol, pageWriter.getAllocator());
        this.dataColumn = parquetProps.getValuesWriter(path, initialSizePerCol);
    }

    private void initStatistics() {
        this.statistics = Statistics.getStatsBasedOnType(this.path.getType());
    }

    private void log(Object value, int r, int d) {
        LOG.debug((Object)(this.path + " " + value + " r:" + r + " d:" + d));
    }

    private void resetStatistics() {
        this.statistics = Statistics.getStatsBasedOnType(this.path.getType());
    }

    private void accountForValueWritten() {
        ++this.valueCount;
        if (this.valueCount > this.valueCountForNextSizeCheck) {
            long memSize = this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize();
            if (memSize > this.pageSizeThreshold) {
                this.valueCountForNextSizeCheck = this.valueCount / 2;
                this.writePage();
            } else {
                this.valueCountForNextSizeCheck = (int)((float)this.valueCount + (float)this.valueCount * (float)this.pageSizeThreshold / (float)memSize) / 2 + 1;
            }
        }
    }

    private void updateStatisticsNumNulls() {
        this.statistics.incrementNumNulls();
    }

    private void updateStatistics(int value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(long value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(float value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(double value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(Binary value) {
        this.statistics.updateStats(value);
    }

    private void updateStatistics(boolean value) {
        this.statistics.updateStats(value);
    }

    private void writePage() {
        if (DEBUG) {
            LOG.debug((Object)"write page");
        }
        try {
            this.pageWriter.writePage(BytesInput.concat((BytesInput[])new BytesInput[]{this.repetitionLevelColumn.getBytes(), this.definitionLevelColumn.getBytes(), this.dataColumn.getBytes()}), this.valueCount, this.statistics, this.repetitionLevelColumn.getEncoding(), this.definitionLevelColumn.getEncoding(), this.dataColumn.getEncoding());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page for " + this.path, e);
        }
        this.repetitionLevelColumn.reset();
        this.definitionLevelColumn.reset();
        this.dataColumn.reset();
        this.valueCount = 0;
        this.resetStatistics();
    }

    @Override
    public void writeNull(int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(null, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.updateStatisticsNumNulls();
        this.accountForValueWritten();
    }

    @Override
    public void write(double value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeDouble(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(float value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(Float.valueOf(value), repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeFloat(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(Binary value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBytes(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(boolean value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBoolean(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(int value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeInteger(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(long value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeLong(value);
        this.updateStatistics(value);
        this.accountForValueWritten();
    }

    @Override
    public void flush() {
        DictionaryPage dictionaryPage;
        if (this.valueCount > 0) {
            this.writePage();
        }
        if ((dictionaryPage = this.dataColumn.createDictionaryPage()) != null) {
            if (DEBUG) {
                LOG.debug((Object)"write dictionary");
            }
            try {
                this.pageWriter.writeDictionaryPage(dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not write dictionary page for " + this.path, e);
            }
            this.dataColumn.resetDictionary();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.repetitionLevelColumn.close();
        this.definitionLevelColumn.close();
        this.dataColumn.close();
    }

    @Override
    public long getBufferedSizeInMemory() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    public long allocatedSize() {
        return this.repetitionLevelColumn.getAllocatedSize() + this.definitionLevelColumn.getAllocatedSize() + this.dataColumn.getAllocatedSize() + this.pageWriter.allocatedSize();
    }

    public String memUsageString(String indent) {
        StringBuilder b = new StringBuilder(indent).append(this.path).append(" {\n");
        b.append(this.repetitionLevelColumn.memUsageString(String.valueOf(indent) + "  r:")).append("\n");
        b.append(this.definitionLevelColumn.memUsageString(String.valueOf(indent) + "  d:")).append("\n");
        b.append(this.dataColumn.memUsageString(String.valueOf(indent) + "  data:")).append("\n");
        b.append(this.pageWriter.memUsageString(String.valueOf(indent) + "  pages:")).append("\n");
        b.append(indent).append(String.format("  total: %,d/%,d", this.getBufferedSizeInMemory(), this.allocatedSize())).append("\n");
        b.append(indent).append("}\n");
        return b.toString();
    }
}

