/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.impl;

import parquet.column.ColumnDescriptor;
import parquet.column.ColumnReadStore;
import parquet.column.ColumnReader;
import parquet.column.impl.ColumnReaderImpl;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema) {
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path) {
        return this.newMemColumnReader(path, this.pageReadStore.getPageReader(path));
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        return new ColumnReaderImpl(path, pageReader, converter);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        String[] stringArray = path.getPath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName);
            currentType = groupType.getType(fieldName);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
            ++n2;
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

