/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.store.hive.schema.DrillHiveTable;
import org.apache.drill.exec.store.hive.schema.DrillHiveViewTable;
import org.apache.drill.exec.store.hive.schema.HiveDatabaseSchema;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaFactory
implements SchemaFactory {
    static final Logger logger = LoggerFactory.getLogger(HiveSchemaFactory.class);
    private static final String DATABASES = "databases";
    private final HiveMetaStoreClient mClient;
    private LoadingCache<String, List<String>> databases;
    private LoadingCache<String, List<String>> tableNameLoader;
    private LoadingCache<String, LoadingCache<String, HiveReadEntry>> tableLoaders;
    private HiveStoragePlugin plugin;
    private final String schemaName;
    private final Map<String, String> hiveConfigOverride;

    public HiveSchemaFactory(HiveStoragePlugin plugin, String name, Map<String, String> hiveConfigOverride) throws ExecutionSetupException {
        this.schemaName = name;
        this.plugin = plugin;
        this.hiveConfigOverride = hiveConfigOverride;
        HiveConf hiveConf = new HiveConf();
        if (hiveConfigOverride != null) {
            for (Map.Entry<String, String> entry : hiveConfigOverride.entrySet()) {
                hiveConf.set(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.mClient = new HiveMetaStoreClient(hiveConf);
        }
        catch (MetaException e) {
            throw new ExecutionSetupException("Failure setting up Hive metastore client.", (Throwable)e);
        }
        this.databases = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new DatabaseLoader());
        this.tableNameLoader = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TableNameLoader());
        this.tableLoaders = CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).maximumSize(20L).build((CacheLoader)new TableLoaderLoader());
    }

    public void registerSchemas(UserSession session, SchemaPlus parent) {
        HiveSchema schema = new HiveSchema(this.schemaName);
        SchemaPlus hPlus = parent.add(this.schemaName, (Schema)schema);
        schema.setHolder(hPlus);
    }

    class HiveSchema
    extends AbstractSchema {
        private HiveDatabaseSchema defaultSchema;

        public HiveSchema(String name) {
            super((List)ImmutableList.of(), name);
            this.getSubSchema("default");
        }

        public Schema getSubSchema(String name) {
            try {
                List dbs = (List)HiveSchemaFactory.this.databases.get((Object)HiveSchemaFactory.DATABASES);
                if (!dbs.contains(name)) {
                    logger.debug(String.format("Database '%s' doesn't exists in Hive storage '%s'", name, HiveSchemaFactory.this.schemaName));
                    return null;
                }
                List tables = (List)HiveSchemaFactory.this.tableNameLoader.get((Object)name);
                HiveDatabaseSchema schema = new HiveDatabaseSchema(tables, this, name);
                if (name.equals("default")) {
                    this.defaultSchema = schema;
                }
                return schema;
            }
            catch (ExecutionException e) {
                logger.warn("Failure while attempting to access HiveDatabase '{}'.", (Object)name, (Object)e.getCause());
                return null;
            }
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                plusOfThis.add(s, this.getSubSchema(s));
            }
        }

        public boolean showInInformationSchema() {
            return false;
        }

        public Set<String> getSubSchemaNames() {
            try {
                List dbs = (List)HiveSchemaFactory.this.databases.get((Object)HiveSchemaFactory.DATABASES);
                return Sets.newHashSet((Iterable)dbs);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while getting Hive database list.", (Throwable)e);
                return super.getSubSchemaNames();
            }
        }

        public net.hydromatic.optiq.Table getTable(String name) {
            if (this.defaultSchema == null) {
                return super.getTable(name);
            }
            return this.defaultSchema.getTable(name);
        }

        public Set<String> getTableNames() {
            if (this.defaultSchema == null) {
                return super.getTableNames();
            }
            return this.defaultSchema.getTableNames();
        }

        List<String> getTableNames(String dbName) {
            try {
                return (List)HiveSchemaFactory.this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while loading table names for database '{}'.", (Object)dbName, (Object)e.getCause());
                return Collections.emptyList();
            }
        }

        DrillTable getDrillTable(String dbName, String t) {
            HiveReadEntry entry = this.getSelectionBaseOnName(dbName, t);
            if (entry == null) {
                return null;
            }
            if (entry.getJdbcTableType() == Schema.TableType.VIEW) {
                return new DrillHiveViewTable(HiveSchemaFactory.this.schemaName, HiveSchemaFactory.this.plugin, entry);
            }
            return new DrillHiveTable(HiveSchemaFactory.this.schemaName, HiveSchemaFactory.this.plugin, entry);
        }

        HiveReadEntry getSelectionBaseOnName(String dbName, String t) {
            if (dbName == null) {
                dbName = "default";
            }
            try {
                return (HiveReadEntry)((LoadingCache)HiveSchemaFactory.this.tableLoaders.get((Object)dbName)).get((Object)t);
            }
            catch (ExecutionException e) {
                logger.warn("Exception occurred while trying to read table. {}.{}", new Object[]{dbName, t, e.getCause()});
                return null;
            }
        }

        public AbstractSchema getDefaultSchema() {
            return this.defaultSchema;
        }

        public String getTypeName() {
            return "hive";
        }
    }

    private class TableLoader
    extends CacheLoader<String, HiveReadEntry> {
        private final String dbName;

        public TableLoader(String dbName) {
            this.dbName = dbName;
        }

        public HiveReadEntry load(String key) throws Exception {
            Table t = null;
            try {
                t = HiveSchemaFactory.this.mClient.getTable(this.dbName, key);
            }
            catch (TException e) {
                HiveSchemaFactory.this.mClient.reconnect();
                t = HiveSchemaFactory.this.mClient.getTable(this.dbName, key);
            }
            if (t == null) {
                throw new UnknownTableException(String.format("Unable to find table '%s'.", key));
            }
            List partitions = null;
            try {
                partitions = HiveSchemaFactory.this.mClient.listPartitions(this.dbName, key, (short)Short.MAX_VALUE);
            }
            catch (TException e) {
                HiveSchemaFactory.this.mClient.reconnect();
                partitions = HiveSchemaFactory.this.mClient.listPartitions(this.dbName, key, (short)Short.MAX_VALUE);
            }
            ArrayList hivePartitions = Lists.newArrayList();
            for (Partition part : partitions) {
                hivePartitions.add(new HiveTable.HivePartition(part));
            }
            if (hivePartitions.size() == 0) {
                hivePartitions = null;
            }
            return new HiveReadEntry(new HiveTable(t), hivePartitions, HiveSchemaFactory.this.hiveConfigOverride);
        }
    }

    private class TableLoaderLoader
    extends CacheLoader<String, LoadingCache<String, HiveReadEntry>> {
        private TableLoaderLoader() {
        }

        public LoadingCache<String, HiveReadEntry> load(String key) throws Exception {
            return CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TableLoader(key));
        }
    }

    private class DatabaseLoader
    extends CacheLoader<String, List<String>> {
        private DatabaseLoader() {
        }

        public List<String> load(String key) throws Exception {
            if (!HiveSchemaFactory.DATABASES.equals(key)) {
                throw new UnsupportedOperationException();
            }
            try {
                return HiveSchemaFactory.this.mClient.getAllDatabases();
            }
            catch (TException e) {
                logger.warn("Failure while attempting to get hive tables", (Throwable)e);
                HiveSchemaFactory.this.mClient.reconnect();
                return HiveSchemaFactory.this.mClient.getAllDatabases();
            }
        }
    }

    private class TableNameLoader
    extends CacheLoader<String, List<String>> {
        private TableNameLoader() {
        }

        public List<String> load(String dbName) throws Exception {
            try {
                return HiveSchemaFactory.this.mClient.getAllTables(dbName);
            }
            catch (TException e) {
                logger.warn("Failure while attempting to get hive tables", (Throwable)e);
                HiveSchemaFactory.this.mClient.reconnect();
                return HiveSchemaFactory.this.mClient.getAllTables(dbName);
            }
        }
    }
}

