/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.InputSplit;

@JsonTypeName(value="hive-sub-scan")
public class HiveSubScan
extends AbstractBase
implements SubScan {
    private List<String> splits;
    private HiveReadEntry hiveReadEntry;
    private List<String> splitClasses;
    private List<SchemaPath> columns;
    @JsonIgnore
    private List<InputSplit> inputSplits = Lists.newArrayList();
    @JsonIgnore
    private Table table;
    @JsonIgnore
    private List<Partition> partitions;

    @JsonCreator
    public HiveSubScan(@JsonProperty(value="splits") List<String> splits, @JsonProperty(value="hiveReadEntry") HiveReadEntry hiveReadEntry, @JsonProperty(value="splitClasses") List<String> splitClasses, @JsonProperty(value="columns") List<SchemaPath> columns) throws IOException, ReflectiveOperationException {
        this.hiveReadEntry = hiveReadEntry;
        this.table = hiveReadEntry.getTable();
        this.partitions = hiveReadEntry.getPartitions();
        this.splits = splits;
        this.splitClasses = splitClasses;
        this.columns = columns;
        for (int i = 0; i < splits.size(); ++i) {
            this.inputSplits.add(HiveSubScan.deserializeInputSplit(splits.get(i), splitClasses.get(i)));
        }
    }

    public List<String> getSplits() {
        return this.splits;
    }

    public Table getTable() {
        return this.table;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public List<String> getSplitClasses() {
        return this.splitClasses;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public List<InputSplit> getInputSplits() {
        return this.inputSplits;
    }

    public HiveReadEntry getHiveReadEntry() {
        return this.hiveReadEntry;
    }

    public static InputSplit deserializeInputSplit(String base64, String className) throws IOException, ReflectiveOperationException {
        Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(new Class[0]);
        if (constructor == null) {
            throw new ReflectiveOperationException("Class " + className + " does not implement a default constructor.");
        }
        constructor.setAccessible(true);
        InputSplit split = (InputSplit)constructor.newInstance(new Object[0]);
        ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])Base64.decodeBase64((String)base64));
        split.readFields((DataInput)byteArrayDataInput);
        return split;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        try {
            return new HiveSubScan(this.splits, this.hiveReadEntry, this.splitClasses, this.columns);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public Iterator<PhysicalOperator> iterator() {
        return Iterators.emptyIterator();
    }

    public int getOperatorType() {
        return 22;
    }
}

