/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.impl.hive.DrillBigIntObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillBitObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillDateObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillDecimal38SparseObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillFloat4ObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillFloat8ObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillIntObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillSmallIntObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillTimeStampObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillTinyIntObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillVar16CharObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillVarBinaryObjectInspector;
import org.apache.drill.exec.expr.fn.impl.hive.DrillVarCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInspectorHelper {
    static final Logger logger = LoggerFactory.getLogger(ObjectInspectorHelper.class);
    private static Map<TypeProtos.MinorType, Class> OIMAP_REQUIRED = new HashMap<TypeProtos.MinorType, Class>();
    private static Map<TypeProtos.MinorType, Class> OIMAP_OPTIONAL = new HashMap<TypeProtos.MinorType, Class>();
    private static Map<PrimitiveObjectInspector.PrimitiveCategory, TypeProtos.MinorType> TYPE_HIVE2DRILL;

    public static ObjectInspector getDrillObjectInspector(TypeProtos.DataMode mode, TypeProtos.MinorType minorType) {
        block6: {
            try {
                if (mode == TypeProtos.DataMode.REQUIRED) {
                    if (OIMAP_REQUIRED.containsKey(minorType)) {
                        return (ObjectInspector)OIMAP_REQUIRED.get(minorType).newInstance();
                    }
                    break block6;
                }
                if (mode == TypeProtos.DataMode.OPTIONAL) {
                    if (OIMAP_OPTIONAL.containsKey(minorType)) {
                        return (ObjectInspector)OIMAP_OPTIONAL.get(minorType).newInstance();
                    }
                    break block6;
                }
                throw new UnsupportedOperationException("Repeated types are not supported as arguement to Hive UDFs");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate ObjectInspector", e);
            }
        }
        throw new UnsupportedOperationException(String.format("Type %s[%s] not supported as arguement to Hive UDFs", minorType.toString(), mode.toString()));
    }

    public static JBlock initReturnValueHolder(ClassGenerator<?> g, JCodeModel m, JVar returnValueHolder, ObjectInspector oi, TypeProtos.MinorType returnType) {
        JBlock block = new JBlock(false, false);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case BYTE: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case SHORT: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case INT: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case LONG: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case FLOAT: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case DOUBLE: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case VARCHAR: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        block.assign((JAssignmentTarget)returnValueHolder.ref("buffer"), (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer").invoke("reallocIfNeeded").arg(JExpr.lit((int)1024)));
                        return block;
                    }
                    case STRING: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        block.assign((JAssignmentTarget)returnValueHolder.ref("buffer"), (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer").invoke("reallocIfNeeded").arg(JExpr.lit((int)1024)));
                        return block;
                    }
                    case BINARY: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        block.assign((JAssignmentTarget)returnValueHolder.ref("buffer"), (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer").invoke("reallocIfNeeded").arg(JExpr.lit((int)1024)));
                        return block;
                    }
                    case TIMESTAMP: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case DECIMAL: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                    case DATE: {
                        JType holderClass = TypeHelper.getHolderType((JCodeModel)m, (TypeProtos.MinorType)returnType, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
                        block.assign((JAssignmentTarget)returnValueHolder, (JExpression)JExpr._new((JType)holderClass));
                        return block;
                    }
                }
                throw new UnsupportedOperationException(String.format("Received unknown/unsupported type '%s'", poi.getPrimitiveCategory().toString()));
            }
        }
        throw new UnsupportedOperationException(String.format("Received unknown/unsupported type '%s'", oi.getCategory().toString()));
    }

    public static TypeProtos.MinorType getDrillType(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                if (TYPE_HIVE2DRILL.containsKey(poi.getPrimitiveCategory())) {
                    return TYPE_HIVE2DRILL.get(poi.getPrimitiveCategory());
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static JBlock getDrillObject(JCodeModel m, ObjectInspector oi, JVar returnOI, JVar returnValueHolder, JVar returnValue) {
        JBlock block = new JBlock(false, false);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(BooleanObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(BooleanObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JConditional booleanJC = jc._else()._if((JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        booleanJC._then().assign((JAssignmentTarget)returnValueHolder.ref("value"), JExpr.lit((int)1));
                        booleanJC._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), JExpr.lit((int)0));
                        return block;
                    }
                    case BYTE: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(ByteObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(ByteObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case SHORT: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(ShortObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(ShortObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case INT: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(IntObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(IntObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case LONG: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(LongObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(LongObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case FLOAT: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(FloatObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(FloatObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case DOUBLE: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(DoubleObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(DoubleObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case VARCHAR: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(HiveVarcharObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(HiveVarcharObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JVar data = jc._else().decl((JType)m.directClass(byte[].class.getCanonicalName()), "data", (JExpression)castedOI.invoke("getPrimitiveJavaObject").arg((JExpression)returnValue).invoke("getValue").invoke("getBytes"));
                        jc._else().add((JStatement)returnValueHolder.ref("buffer").invoke("setBytes").arg(JExpr.lit((int)0)).arg((JExpression)data));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("start"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("end"), (JExpression)data.ref("length"));
                        return block;
                    }
                    case STRING: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(StringObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(StringObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JVar data = jc._else().decl((JType)m.directClass(byte[].class.getCanonicalName()), "data", (JExpression)castedOI.invoke("getPrimitiveJavaObject").arg((JExpression)returnValue).invoke("getBytes").arg((JExpression)DirectExpression.direct((String)"com.google.common.base.Charsets.UTF_16")));
                        jc._else().add((JStatement)returnValueHolder.ref("buffer").invoke("setBytes").arg(JExpr.lit((int)0)).arg((JExpression)data));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("start"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("end"), (JExpression)data.ref("length"));
                        return block;
                    }
                    case BINARY: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(BinaryObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(BinaryObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JVar data = jc._else().decl((JType)m.directClass(byte[].class.getCanonicalName()), "data", (JExpression)castedOI.invoke("getPrimitiveJavaObject").arg((JExpression)returnValue));
                        jc._else().add((JStatement)returnValueHolder.ref("buffer").invoke("setBytes").arg(JExpr.lit((int)0)).arg((JExpression)data));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("start"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("end"), (JExpression)data.ref("length"));
                        return block;
                    }
                    case TIMESTAMP: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(TimestampObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(TimestampObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JVar tsVar = jc._else().decl((JType)m.directClass(Timestamp.class.getCanonicalName()), "ts", (JExpression)castedOI.invoke("getPrimitiveJavaObject").arg((JExpression)returnValue));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)tsVar.invoke("getTime"));
                        return block;
                    }
                    case DECIMAL: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(HiveDecimalObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(HiveDecimalObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)castedOI.invoke("get").arg((JExpression)returnValue));
                        return block;
                    }
                    case DATE: {
                        JConditional jc = block._if(returnValue.eq(JExpr._null()));
                        jc._then().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)0));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("isSet"), JExpr.lit((int)1));
                        JVar castedOI = jc._else().decl((JType)m.directClass(DateObjectInspector.class.getCanonicalName()), "castOI", JExpr._null());
                        jc._else().assign((JAssignmentTarget)castedOI, (JExpression)JExpr.cast((JType)m.directClass(DateObjectInspector.class.getCanonicalName()), (JExpression)returnOI));
                        JVar dVar = jc._else().decl((JType)m.directClass(Date.class.getCanonicalName()), "d", (JExpression)castedOI.invoke("getPrimitiveJavaObject").arg((JExpression)returnValue));
                        jc._else().assign((JAssignmentTarget)returnValueHolder.ref("value"), (JExpression)dVar.invoke("getTime"));
                        return block;
                    }
                }
                throw new UnsupportedOperationException(String.format("Received unknown/unsupported type '%s'", poi.getPrimitiveCategory().toString()));
            }
        }
        throw new UnsupportedOperationException(String.format("Received unknown/unsupported type '%s'", oi.getCategory().toString()));
    }

    static {
        OIMAP_REQUIRED.put(TypeProtos.MinorType.BIT, DrillBitObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.BIT, DrillBitObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.TINYINT, DrillTinyIntObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.TINYINT, DrillTinyIntObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.SMALLINT, DrillSmallIntObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.SMALLINT, DrillSmallIntObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.INT, DrillIntObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.INT, DrillIntObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.BIGINT, DrillBigIntObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.BIGINT, DrillBigIntObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.FLOAT4, DrillFloat4ObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.FLOAT4, DrillFloat4ObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.FLOAT8, DrillFloat8ObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.FLOAT8, DrillFloat8ObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.VARCHAR, DrillVarCharObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.VARCHAR, DrillVarCharObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.VAR16CHAR, DrillVar16CharObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.VAR16CHAR, DrillVar16CharObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.VARBINARY, DrillVarBinaryObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.VARBINARY, DrillVarBinaryObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.TIMESTAMP, DrillTimeStampObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.TIMESTAMP, DrillTimeStampObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.DECIMAL38SPARSE, DrillDecimal38SparseObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.DECIMAL38SPARSE, DrillDecimal38SparseObjectInspector.Optional.class);
        OIMAP_REQUIRED.put(TypeProtos.MinorType.DATE, DrillDateObjectInspector.Required.class);
        OIMAP_OPTIONAL.put(TypeProtos.MinorType.DATE, DrillDateObjectInspector.Optional.class);
        TYPE_HIVE2DRILL = new HashMap<PrimitiveObjectInspector.PrimitiveCategory, TypeProtos.MinorType>();
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, TypeProtos.MinorType.BIT);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, TypeProtos.MinorType.TINYINT);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, TypeProtos.MinorType.SMALLINT);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.INT, TypeProtos.MinorType.INT);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, TypeProtos.MinorType.BIGINT);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, TypeProtos.MinorType.FLOAT4);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, TypeProtos.MinorType.FLOAT8);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, TypeProtos.MinorType.VARCHAR);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, TypeProtos.MinorType.VAR16CHAR);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.BINARY, TypeProtos.MinorType.VARBINARY);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, TypeProtos.MinorType.TIMESTAMP);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, TypeProtos.MinorType.DECIMAL38SPARSE);
        TYPE_HIVE2DRILL.put(PrimitiveObjectInspector.PrimitiveCategory.DATE, TypeProtos.MinorType.DATE);
    }
}

