/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;

public abstract class DrillVarBinaryObjectInspector
extends AbstractDrillPrimitiveObjectInspector
implements BinaryObjectInspector {
    public DrillVarBinaryObjectInspector() {
        super(PrimitiveObjectInspectorUtils.binaryTypeEntry);
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        return new BytesWritable(this.getPrimitiveJavaObject(o));
    }

    public static class Optional
    extends DrillVarBinaryObjectInspector {
        public byte[] getPrimitiveJavaObject(Object o) {
            NullableVarBinaryHolder h = (NullableVarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return buf;
        }
    }

    public static class Required
    extends DrillVarBinaryObjectInspector {
        public byte[] getPrimitiveJavaObject(Object o) {
            VarBinaryHolder h = (VarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return buf;
        }
    }
}

