/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase.config;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.hbase.config.HBasePStoreProvider;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBasePStore<V>
implements PStore<V> {
    static final Logger logger = LoggerFactory.getLogger(HBasePStore.class);
    private final PStoreConfig<V> config;
    private final HTableInterface table;
    private final String tableName;
    private final byte[] tableNameStartKey;
    private final byte[] tableNameStopKey;

    public HBasePStore(PStoreConfig<V> config, HTableInterface table) throws IOException {
        this.tableName = config.getName() + '\u0000';
        this.tableNameStartKey = Bytes.toBytes((String)this.tableName);
        this.tableNameStopKey = (byte[])this.tableNameStartKey.clone();
        this.tableNameStopKey[this.tableNameStartKey.length - 1] = 1;
        this.config = config;
        this.table = table;
    }

    public V get(String key) {
        return this.get(key, HBasePStoreProvider.FAMILY);
    }

    protected synchronized V get(String key, byte[] family) {
        try {
            Get get = new Get(this.row(key));
            get.addColumn(family, HBasePStoreProvider.QUALIFIER);
            Result r = this.table.get(get);
            if (r.isEmpty()) {
                return null;
            }
            return this.value(r);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Caught error while getting row '" + key + "' from for table:" + Bytes.toString((byte[])this.table.getTableName()), (Throwable)e);
        }
    }

    public void put(String key, V value) {
        this.put(key, HBasePStoreProvider.FAMILY, value);
    }

    protected synchronized void put(String key, byte[] family, V value) {
        try {
            Put put = new Put(this.row(key));
            put.add(family, HBasePStoreProvider.QUALIFIER, this.bytes(value));
            this.table.put(put);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Caught error while putting row '" + key + "' from for table:" + Bytes.toString((byte[])this.table.getTableName()), (Throwable)e);
        }
    }

    public synchronized boolean putIfAbsent(String key, V value) {
        try {
            Put put = new Put(this.row(key));
            put.add(HBasePStoreProvider.FAMILY, HBasePStoreProvider.QUALIFIER, this.bytes(value));
            return this.table.checkAndPut(put.getRow(), HBasePStoreProvider.FAMILY, HBasePStoreProvider.QUALIFIER, null, put);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Caught error while putting row '" + key + "' from for table:" + Bytes.toString((byte[])this.table.getTableName()), (Throwable)e);
        }
    }

    public synchronized void delete(String key) {
        this.delete(this.row(key));
    }

    public Iterator<Map.Entry<String, V>> iterator() {
        return new Iter();
    }

    private byte[] row(String key) {
        return Bytes.toBytes((String)(this.tableName + key));
    }

    private byte[] bytes(V value) {
        try {
            return this.config.getSerializer().serialize(value);
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    private V value(Result result) {
        try {
            return (V)this.config.getSerializer().deserialize(result.value());
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    private void delete(byte[] row) {
        try {
            Delete del = new Delete(row);
            this.table.delete(del);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Caught error while deleting row '" + Bytes.toStringBinary((byte[])row) + "' from for table:" + Bytes.toString((byte[])this.table.getTableName()), (Throwable)e);
        }
    }

    private class DeferredEntry
    implements Map.Entry<String, V> {
        private Result result;

        public DeferredEntry(Result result) {
            this.result = result;
        }

        @Override
        public String getKey() {
            return Bytes.toString((byte[])this.result.getRow(), (int)HBasePStore.this.tableNameStartKey.length, (int)(this.result.getRow().length - HBasePStore.this.tableNameStartKey.length));
        }

        @Override
        public V getValue() {
            return HBasePStore.this.value(this.result);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator<Map.Entry<String, V>> {
        private ResultScanner scanner;
        private Result current = null;
        private Result last = null;
        private boolean done = false;

        Iter() {
            try {
                Scan scan = new Scan(HBasePStore.this.tableNameStartKey, HBasePStore.this.tableNameStopKey);
                scan.addColumn(HBasePStoreProvider.FAMILY, HBasePStoreProvider.QUALIFIER);
                scan.setCaching(100);
                this.scanner = HBasePStore.this.table.getScanner(scan);
            }
            catch (IOException e) {
                throw new DrillRuntimeException("Caught error while creating HBase scanner for table:" + Bytes.toString((byte[])HBasePStore.this.table.getTableName()), (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.done && this.current == null) {
                try {
                    this.current = this.scanner.next();
                    if (this.current == null) {
                        this.done = true;
                        this.scanner.close();
                    }
                }
                catch (IOException e) {
                    throw new DrillRuntimeException("Caught error while fetching rows from for table:" + Bytes.toString((byte[])HBasePStore.this.table.getTableName()), (Throwable)e);
                }
            }
            return this.current != null;
        }

        @Override
        public Map.Entry<String, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.current;
            this.current = null;
            return new DeferredEntry(this.last);
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("remove() called on HBase persistent store iterator, but there is no last row.");
            }
            HBasePStore.this.delete(this.last.getRow());
        }
    }
}

