/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hbase.HBaseStoragePlugin;
import org.apache.drill.exec.store.hbase.HBaseStoragePluginConfig;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.org.codehaus.jackson.annotate.JsonCreator;

@JsonTypeName(value="hbase-region-scan")
public class HBaseSubScan
extends AbstractBase
implements SubScan {
    static final Logger logger = LoggerFactory.getLogger(HBaseSubScan.class);
    @JsonProperty
    public final HBaseStoragePluginConfig storage;
    @JsonIgnore
    private final HBaseStoragePlugin hbaseStoragePlugin;
    private final List<HBaseSubScanSpec> regionScanSpecList;
    private final List<SchemaPath> columns;

    @com.fasterxml.jackson.annotation.JsonCreator
    public HBaseSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="storage") StoragePluginConfig storage, @JsonProperty(value="regionScanSpecList") LinkedList<HBaseSubScanSpec> regionScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) throws ExecutionSetupException {
        this.hbaseStoragePlugin = (HBaseStoragePlugin)registry.getPlugin(storage);
        this.regionScanSpecList = regionScanSpecList;
        this.storage = (HBaseStoragePluginConfig)storage;
        this.columns = columns;
    }

    public HBaseSubScan(HBaseStoragePlugin plugin, HBaseStoragePluginConfig config, List<HBaseSubScanSpec> regionInfoList, List<SchemaPath> columns) {
        this.hbaseStoragePlugin = plugin;
        this.storage = config;
        this.regionScanSpecList = regionInfoList;
        this.columns = columns;
    }

    public List<HBaseSubScanSpec> getRegionScanSpecList() {
        return this.regionScanSpecList;
    }

    @JsonIgnore
    public HBaseStoragePluginConfig getStorageConfig() {
        return this.storage;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public boolean isExecutable() {
        return false;
    }

    @JsonIgnore
    public HBaseStoragePlugin getStorageEngine() {
        return this.hbaseStoragePlugin;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new HBaseSubScan(this.hbaseStoragePlugin, this.storage, this.regionScanSpecList, this.columns);
    }

    public Iterator<PhysicalOperator> iterator() {
        return Iterators.emptyIterator();
    }

    public int getOperatorType() {
        return 33;
    }

    public static class HBaseSubScanSpec {
        protected String tableName;
        protected String regionServer;
        protected byte[] startRow;
        protected byte[] stopRow;
        protected byte[] serializedFilter;
        @JsonIgnore
        private Filter scanFilter;

        @JsonCreator
        public HBaseSubScanSpec(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="regionServer") String regionServer, @JsonProperty(value="startRow") byte[] startRow, @JsonProperty(value="stopRow") byte[] stopRow, @JsonProperty(value="serializedFilter") byte[] serializedFilter, @JsonProperty(value="filterString") String filterString) {
            if (serializedFilter != null && filterString != null) {
                throw new IllegalArgumentException("The parameters 'serializedFilter' or 'filterString' cannot be specified at the same time.");
            }
            this.tableName = tableName;
            this.regionServer = regionServer;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.serializedFilter = serializedFilter != null ? serializedFilter : HBaseUtils.serializeFilter(HBaseUtils.parseFilterString(filterString));
        }

        HBaseSubScanSpec() {
        }

        public Filter getScanFilter() {
            if (this.scanFilter == null && this.serializedFilter != null) {
                this.scanFilter = HBaseUtils.deserializeFilter(this.serializedFilter);
            }
            return this.scanFilter;
        }

        public String getTableName() {
            return this.tableName;
        }

        public HBaseSubScanSpec setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public String getRegionServer() {
            return this.regionServer;
        }

        public HBaseSubScanSpec setRegionServer(String regionServer) {
            this.regionServer = regionServer;
            return this;
        }

        public byte[] getStartRow() {
            return this.startRow;
        }

        public HBaseSubScanSpec setStartRow(byte[] startRow) {
            this.startRow = startRow;
            return this;
        }

        public byte[] getStopRow() {
            return this.stopRow;
        }

        public HBaseSubScanSpec setStopRow(byte[] stopRow) {
            this.stopRow = stopRow;
            return this;
        }

        public byte[] getSerializedFilter() {
            return this.serializedFilter;
        }

        public HBaseSubScanSpec setSerializedFilter(byte[] serializedFilter) {
            this.serializedFilter = serializedFilter;
            this.scanFilter = null;
            return this;
        }

        public String toString() {
            return "HBaseScanSpec [tableName=" + this.tableName + ", startRow=" + (this.startRow == null ? null : Bytes.toStringBinary((byte[])this.startRow)) + ", stopRow=" + (this.stopRow == null ? null : Bytes.toStringBinary((byte[])this.stopRow)) + ", filter=" + (this.getScanFilter() == null ? null : this.getScanFilter().toString()) + ", regionServer=" + this.regionServer + "]";
        }
    }
}

