/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.drill.common.logical.StoragePluginConfigBase;
import org.apache.drill.exec.store.hbase.DrillHBaseConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hbase")
public class HBaseStoragePluginConfig
extends StoragePluginConfigBase
implements DrillHBaseConstants {
    static final Logger logger = LoggerFactory.getLogger(HBaseStoragePluginConfig.class);
    private Map<String, String> config;
    @JsonIgnore
    private Configuration hbaseConf;
    @JsonIgnore
    private Boolean sizeCalculatorEnabled;
    public static final String NAME = "hbase";

    @JsonCreator
    public HBaseStoragePluginConfig(@JsonProperty(value="config") Map<String, String> props, @JsonProperty(value="size.calculator.enabled") Boolean sizeCalculatorEnabled) {
        this.config = props;
        if (this.config == null) {
            this.config = Maps.newHashMap();
        }
        logger.debug("Initializing HBase StoragePlugin configuration with zookeeper quorum '{}', port '{}'.", (Object)this.config.get("hbase.zookeeper.quorum"), (Object)this.config.get("hbase.zookeeper.property.clientPort"));
        this.sizeCalculatorEnabled = sizeCalculatorEnabled == null ? Boolean.valueOf(false) : sizeCalculatorEnabled;
    }

    @JsonProperty
    public Map<String, String> getConfig() {
        return ImmutableMap.copyOf(this.config);
    }

    @JsonProperty(value="size.calculator.enabled")
    public boolean isSizeCalculatorEnabled() {
        return this.sizeCalculatorEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HBaseStoragePluginConfig that = (HBaseStoragePluginConfig)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config != null ? this.config.hashCode() : 0;
    }

    @JsonIgnore
    public Configuration getHBaseConf() {
        if (this.hbaseConf == null) {
            this.hbaseConf = HBaseConfiguration.create();
            if (this.config != null) {
                for (Map.Entry<String, String> entry : this.config.entrySet()) {
                    this.hbaseConf.set(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.hbaseConf;
    }

    @JsonIgnore
    public String getZookeeperQuorum() {
        return this.getHBaseConf().get("hbase.zookeeper.quorum");
    }

    @JsonIgnore
    public String getZookeeperport() {
        return this.getHBaseConf().get("hbase.zookeeper.property.clientPort");
    }

    @JsonIgnore
    @VisibleForTesting
    public void setZookeeperPort(int zookeeperPort) {
        this.config.put("hbase.zookeeper.property.clientPort", String.valueOf(zookeeperPort));
        this.getHBaseConf().setInt("hbase.zookeeper.property.clientPort", zookeeperPort);
    }
}

