/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseScanSpec {
    protected String tableName;
    protected byte[] startRow;
    protected byte[] stopRow;
    protected Filter filter;

    @JsonCreator
    public HBaseScanSpec(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="startRow") byte[] startRow, @JsonProperty(value="stopRow") byte[] stopRow, @JsonProperty(value="serializedFilter") byte[] serializedFilter, @JsonProperty(value="filterString") String filterString) {
        if (serializedFilter != null && filterString != null) {
            throw new IllegalArgumentException("The parameters 'serializedFilter' or 'filterString' cannot be specified at the same time.");
        }
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.filter = filterString != null ? HBaseUtils.parseFilterString(filterString) : HBaseUtils.deserializeFilter(serializedFilter);
    }

    public HBaseScanSpec(String tableName, byte[] startRow, byte[] stopRow, Filter filter) {
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.filter = filter;
    }

    public HBaseScanSpec(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return this.startRow == null ? HConstants.EMPTY_START_ROW : this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow == null ? HConstants.EMPTY_START_ROW : this.stopRow;
    }

    @JsonIgnore
    public Filter getFilter() {
        return this.filter;
    }

    public byte[] getSerializedFilter() {
        return this.filter != null ? HBaseUtils.serializeFilter(this.filter) : null;
    }

    public String toString() {
        return "HBaseScanSpec [tableName=" + this.tableName + ", startRow=" + (this.startRow == null ? null : Bytes.toStringBinary((byte[])this.startRow)) + ", stopRow=" + (this.stopRow == null ? null : Bytes.toStringBinary((byte[])this.stopRow)) + ", filter=" + (this.filter == null ? null : this.filter.toString()) + "]";
    }
}

