/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hbase.DrillHBaseConstants;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.exec.store.hbase.HBaseStoragePlugin;
import org.apache.drill.exec.store.hbase.HBaseStoragePluginConfig;
import org.apache.drill.exec.store.hbase.HBaseSubScan;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.drill.exec.store.hbase.TableStatsCalculator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.org.codehaus.jackson.annotate.JsonCreator;

@JsonTypeName(value="hbase-scan")
public class HBaseGroupScan
extends AbstractGroupScan
implements DrillHBaseConstants {
    static final Logger logger = LoggerFactory.getLogger(HBaseGroupScan.class);
    private static final Comparator<List<HBaseSubScan.HBaseSubScanSpec>> LIST_SIZE_COMPARATOR = new Comparator<List<HBaseSubScan.HBaseSubScanSpec>>(){

        @Override
        public int compare(List<HBaseSubScan.HBaseSubScanSpec> list1, List<HBaseSubScan.HBaseSubScanSpec> list2) {
            return list1.size() - list2.size();
        }
    };
    private static final Comparator<List<HBaseSubScan.HBaseSubScanSpec>> LIST_SIZE_COMPARATOR_REV = Collections.reverseOrder(LIST_SIZE_COMPARATOR);
    private HBaseStoragePluginConfig storagePluginConfig;
    private List<SchemaPath> columns;
    private HBaseScanSpec hbaseScanSpec;
    private HBaseStoragePlugin storagePlugin;
    private Stopwatch watch = new Stopwatch();
    private Map<Integer, List<HBaseSubScan.HBaseSubScanSpec>> endpointFragmentMapping;
    private NavigableMap<HRegionInfo, ServerName> regionsToScan;
    private HTableDescriptor hTableDesc;
    private boolean filterPushedDown = false;
    private TableStatsCalculator statsCalculator;
    private long scanSizeInBytes = 0L;

    @JsonCreator
    public HBaseGroupScan(@JsonProperty(value="hbaseScanSpec") HBaseScanSpec hbaseScanSpec, @JsonProperty(value="storage") HBaseStoragePluginConfig storagePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException, ExecutionSetupException {
        this((HBaseStoragePlugin)pluginRegistry.getPlugin((StoragePluginConfig)storagePluginConfig), hbaseScanSpec, columns);
    }

    public HBaseGroupScan(HBaseStoragePlugin storagePlugin, HBaseScanSpec scanSpec, List<SchemaPath> columns) {
        this.storagePlugin = storagePlugin;
        this.storagePluginConfig = storagePlugin.getConfig();
        this.hbaseScanSpec = scanSpec;
        this.columns = columns == null || columns.size() == 0 ? ALL_COLUMNS : columns;
        this.init();
    }

    private HBaseGroupScan(HBaseGroupScan that) {
        this.columns = that.columns;
        this.hbaseScanSpec = that.hbaseScanSpec;
        this.endpointFragmentMapping = that.endpointFragmentMapping;
        this.regionsToScan = that.regionsToScan;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginConfig = that.storagePluginConfig;
        this.hTableDesc = that.hTableDesc;
        this.filterPushedDown = that.filterPushedDown;
        this.statsCalculator = that.statsCalculator;
        this.scanSizeInBytes = that.scanSizeInBytes;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HBaseGroupScan newScan = new HBaseGroupScan(this);
        newScan.columns = columns;
        newScan.verifyColumns();
        return newScan;
    }

    private void init() {
        logger.debug("Getting region locations");
        try {
            HTable table = new HTable(this.storagePluginConfig.getHBaseConf(), this.hbaseScanSpec.getTableName());
            this.hTableDesc = table.getTableDescriptor();
            NavigableMap regionsMap = table.getRegionLocations();
            this.statsCalculator = new TableStatsCalculator(table, this.hbaseScanSpec, this.storagePlugin.getContext().getConfig(), this.storagePluginConfig);
            boolean foundStartRegion = false;
            this.regionsToScan = new TreeMap<HRegionInfo, ServerName>();
            for (Map.Entry mapEntry : regionsMap.entrySet()) {
                HRegionInfo regionInfo = (HRegionInfo)mapEntry.getKey();
                if (!foundStartRegion && this.hbaseScanSpec.getStartRow() != null && this.hbaseScanSpec.getStartRow().length != 0 && !regionInfo.containsRow(this.hbaseScanSpec.getStartRow())) continue;
                foundStartRegion = true;
                this.regionsToScan.put(regionInfo, (ServerName)mapEntry.getValue());
                this.scanSizeInBytes += this.statsCalculator.getRegionSizeInBytes(regionInfo.getRegionName());
                if (this.hbaseScanSpec.getStopRow() == null || this.hbaseScanSpec.getStopRow().length == 0 || !regionInfo.containsRow(this.hbaseScanSpec.getStopRow())) continue;
                break;
            }
            table.close();
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Error getting region info for table: " + this.hbaseScanSpec.getTableName(), (Throwable)e);
        }
        this.verifyColumns();
    }

    private void verifyColumns() {
        if (AbstractRecordReader.isStarQuery(this.columns)) {
            return;
        }
        for (SchemaPath column : this.columns) {
            if (column.equals((Object)ROW_KEY_PATH) || this.hTableDesc.hasFamily(HBaseUtils.getBytes(column.getRootSegment().getPath()))) continue;
            DrillRuntimeException.format((String)"The column family '%s' does not exist in HBase table: %s .", (Object[])new Object[]{column.getRootSegment().getPath(), this.hTableDesc.getNameAsString()});
        }
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        this.watch.reset();
        this.watch.start();
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint ep : this.storagePlugin.getContext().getBits()) {
            endpointMap.put(ep.getAddress(), ep);
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        for (ServerName sn : this.regionsToScan.values()) {
            CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(sn.getHostname());
            if (ep == null) continue;
            EndpointAffinity affinity = (EndpointAffinity)affinityMap.get(ep);
            if (affinity == null) {
                affinityMap.put(ep, new EndpointAffinity(ep, 1.0f));
                continue;
            }
            affinity.addAffinity(1.0f);
        }
        logger.debug("Took {} \u00b5s to get operator affinity", (Object)(this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L));
        return Lists.newArrayList(affinityMap.values());
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.watch.reset();
        this.watch.start();
        int numSlots = incomingEndpoints.size();
        Preconditions.checkArgument((numSlots <= this.regionsToScan.size() ? 1 : 0) != 0, (Object)String.format("Incoming endpoints %d is greater than number of scan regions %d", numSlots, this.regionsToScan.size()));
        int minPerEndpointSlot = (int)Math.floor((double)this.regionsToScan.size() / (double)numSlots);
        int maxPerEndpointSlot = (int)Math.ceil((double)this.regionsToScan.size() / (double)numSlots);
        this.endpointFragmentMapping = Maps.newHashMapWithExpectedSize((int)numSlots);
        HashMap endpointHostIndexListMap = Maps.newHashMap();
        for (int i = 0; i < numSlots; ++i) {
            this.endpointFragmentMapping.put(i, new ArrayList(maxPerEndpointSlot));
            String hostname = incomingEndpoints.get(i).getAddress();
            Queue hostIndexQueue = (Queue)endpointHostIndexListMap.get(hostname);
            if (hostIndexQueue == null) {
                hostIndexQueue = Lists.newLinkedList();
                endpointHostIndexListMap.put(hostname, hostIndexQueue);
            }
            hostIndexQueue.add(i);
        }
        HashSet regionsToAssignSet = Sets.newHashSet(this.regionsToScan.entrySet());
        Iterator regionsIterator = regionsToAssignSet.iterator();
        while (regionsIterator.hasNext()) {
            Map.Entry regionEntry = (Map.Entry)regionsIterator.next();
            Queue endpointIndexlist = (Queue)endpointHostIndexListMap.get(((ServerName)regionEntry.getValue()).getHostname());
            if (endpointIndexlist == null) continue;
            Integer slotIndex = (Integer)endpointIndexlist.poll();
            List<HBaseSubScan.HBaseSubScanSpec> endpointSlotScanList = this.endpointFragmentMapping.get(slotIndex);
            endpointSlotScanList.add(this.regionInfoToSubScanSpec((HRegionInfo)regionEntry.getKey()));
            endpointIndexlist.offer(slotIndex);
            regionsIterator.remove();
        }
        PriorityQueue<List<HBaseSubScan.HBaseSubScanSpec>> minHeap = new PriorityQueue<List<HBaseSubScan.HBaseSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR);
        PriorityQueue<List<HBaseSubScan.HBaseSubScanSpec>> maxHeap = new PriorityQueue<List<HBaseSubScan.HBaseSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR_REV);
        for (List<HBaseSubScan.HBaseSubScanSpec> listOfScan : this.endpointFragmentMapping.values()) {
            if (listOfScan.size() < minPerEndpointSlot) {
                minHeap.offer(listOfScan);
                continue;
            }
            if (listOfScan.size() <= minPerEndpointSlot) continue;
            maxHeap.offer(listOfScan);
        }
        if (regionsToAssignSet.size() > 0) {
            for (Map.Entry regionEntry : regionsToAssignSet) {
                List<HBaseSubScan.HBaseSubScanSpec> smallestList = minHeap.poll();
                smallestList.add(this.regionInfoToSubScanSpec((HRegionInfo)regionEntry.getKey()));
                if (smallestList.size() >= maxPerEndpointSlot) continue;
                minHeap.offer(smallestList);
            }
        }
        while (minHeap.peek() != null && minHeap.peek().size() < minPerEndpointSlot) {
            List<HBaseSubScan.HBaseSubScanSpec> smallestList = minHeap.poll();
            List<HBaseSubScan.HBaseSubScanSpec> largestList = maxHeap.poll();
            smallestList.add(largestList.remove(largestList.size() - 1));
            if (largestList.size() > minPerEndpointSlot) {
                maxHeap.offer(largestList);
            }
            if (smallestList.size() >= minPerEndpointSlot) continue;
            minHeap.offer(smallestList);
        }
        assert (minHeap.peek() == null || minHeap.peek().size() > 0) : String.format("Unable to assign tasks to some endpoints.\nEndpoints: {}.\nAssignment Map: {}.", incomingEndpoints, this.endpointFragmentMapping.toString());
        logger.debug("Built assignment map in {} \u00b5s.\nEndpoints: {}.\nAssignment Map: {}", new Object[]{this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L, incomingEndpoints, this.endpointFragmentMapping.toString()});
    }

    private HBaseSubScan.HBaseSubScanSpec regionInfoToSubScanSpec(HRegionInfo ri) {
        HBaseScanSpec spec = this.hbaseScanSpec;
        return new HBaseSubScan.HBaseSubScanSpec().setTableName(spec.getTableName()).setRegionServer(((ServerName)this.regionsToScan.get(ri)).getHostname()).setStartRow(!this.isNullOrEmpty(spec.getStartRow()) && ri.containsRow(spec.getStartRow()) ? spec.getStartRow() : ri.getStartKey()).setStopRow(!this.isNullOrEmpty(spec.getStopRow()) && ri.containsRow(spec.getStopRow()) ? spec.getStopRow() : ri.getEndKey()).setSerializedFilter(spec.getSerializedFilter());
    }

    private boolean isNullOrEmpty(byte[] key) {
        return key == null || key.length == 0;
    }

    public HBaseSubScan getSpecificScan(int minorFragmentId) {
        assert (minorFragmentId < this.endpointFragmentMapping.size()) : String.format("Mappings length [%d] should be greater than minor fragment id [%d] but it isn't.", this.endpointFragmentMapping.size(), minorFragmentId);
        return new HBaseSubScan(this.storagePlugin, this.storagePluginConfig, this.endpointFragmentMapping.get(minorFragmentId), this.columns);
    }

    public int getMaxParallelizationWidth() {
        return this.regionsToScan.size();
    }

    public ScanStats getScanStats() {
        int rowCount = (int)((double)(this.scanSizeInBytes / (long)this.statsCalculator.getAvgRowSizeInBytes()) * (this.hbaseScanSpec.getFilter() != null ? 0.5 : 1.0));
        float diskCost = this.scanSizeInBytes * (long)(this.columns == null || this.columns.isEmpty() ? 1 : this.columns.size() / this.statsCalculator.getColsPerRow());
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (long)rowCount, 1.0f, diskCost);
    }

    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new HBaseGroupScan(this);
    }

    @JsonIgnore
    public HBaseStoragePlugin getStoragePlugin() {
        return this.storagePlugin;
    }

    @JsonIgnore
    public Configuration getHBaseConf() {
        return this.getStorageConfig().getHBaseConf();
    }

    @JsonIgnore
    public String getTableName() {
        return this.getHBaseScanSpec().getTableName();
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        return "HBaseGroupScan [HBaseScanSpec=" + this.hbaseScanSpec + ", columns=" + this.columns + "]";
    }

    @JsonProperty(value="storage")
    public HBaseStoragePluginConfig getStorageConfig() {
        return this.storagePluginConfig;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public HBaseScanSpec getHBaseScanSpec() {
        return this.hbaseScanSpec;
    }

    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    @JsonIgnore
    public void setFilterPushedDown(boolean b) {
        this.filterPushedDown = true;
    }

    @JsonIgnore
    public boolean isFilterPushedDown() {
        return this.filterPushedDown;
    }

    @VisibleForTesting
    public HBaseGroupScan() {
    }

    @VisibleForTesting
    public void setHBaseScanSpec(HBaseScanSpec hbaseScanSpec) {
        this.hbaseScanSpec = hbaseScanSpec;
    }

    @JsonIgnore
    @VisibleForTesting
    public void setRegionsToScan(NavigableMap<HRegionInfo, ServerName> regionsToScan) {
        this.regionsToScan = regionsToScan;
    }
}

