/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.hbase.DrillHBaseConstants;
import org.apache.drill.exec.store.hbase.HBaseScanSpec;
import org.apache.drill.exec.store.hbase.HBaseStoragePlugin;
import org.apache.drill.exec.store.hbase.HBaseUtils;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillHBaseTable
extends DrillTable
implements DrillHBaseConstants {
    static final Logger logger = LoggerFactory.getLogger(DrillHBaseTable.class);
    private HTableDescriptor table;

    public DrillHBaseTable(String storageEngineName, HBaseStoragePlugin plugin, HBaseScanSpec scanSpec) {
        super(storageEngineName, (StoragePlugin)plugin, (Object)scanSpec);
        try (HBaseAdmin admin = new HBaseAdmin(plugin.getConfig().getHBaseConf());){
            this.table = admin.getTableDescriptor(HBaseUtils.getBytes(scanSpec.getTableName()));
        }
        catch (IOException e) {
            logger.warn("Failure while loading table names for database '{}'.", (Object)storageEngineName, (Object)e);
        }
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.add("row_key");
        typeList.add(typeFactory.createSqlType(SqlTypeName.ANY));
        Set families = this.table.getFamiliesKeys();
        for (byte[] family : families) {
            fieldNameList.add(Bytes.toString((byte[])family));
            typeList.add(typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.ANY)));
        }
        return typeFactory.createStructType(typeList, fieldNameList);
    }
}

