/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.util.Arrays;
import java.util.Iterator;
import parquet.hadoop.metadata.Canonicalizer;

public final class ColumnPath
implements Iterable<String> {
    private static Canonicalizer<ColumnPath> paths = new Canonicalizer<ColumnPath>(){

        @Override
        protected ColumnPath toCanonical(ColumnPath value) {
            String[] path = new String[value.p.length];
            int i = 0;
            while (i < value.p.length) {
                path[i] = value.p[i].intern();
                ++i;
            }
            return new ColumnPath(path, null);
        }
    };
    private final String[] p;

    public static ColumnPath get(String ... path) {
        return paths.canonicalize(new ColumnPath(path));
    }

    private ColumnPath(String[] path) {
        this.p = path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnPath) {
            return Arrays.equals(this.p, ((ColumnPath)obj).p);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.p);
    }

    public String toString() {
        return Arrays.toString(this.p);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.p).iterator();
    }

    public int size() {
        return this.p.length;
    }

    public String[] toArray() {
        return this.p;
    }

    /* synthetic */ ColumnPath(String[] stringArray, ColumnPath columnPath) {
        this(stringArray);
    }
}

