/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.Map;
import parquet.Log;
import parquet.Preconditions;
import parquet.bytes.ByteBufferAllocator;
import parquet.column.ColumnWriteStore;
import parquet.column.ParquetProperties;
import parquet.column.impl.ColumnWriteStoreImpl;
import parquet.column.page.PageWriteStore;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.ColumnChunkPageWriteStore;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.schema.MessageType;

class InternalParquetRecordWriter<T> {
    private static final Log LOG = Log.getLog(InternalParquetRecordWriter.class);
    private static final int MINIMUM_BUFFER_SIZE = 65536;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    private static final int MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    private final ParquetFileWriter w;
    private final WriteSupport<T> writeSupport;
    private final MessageType schema;
    private final Map<String, String> extraMetaData;
    private final int blockSize;
    private final int pageSize;
    private final CodecFactory.BytesCompressor compressor;
    private final int dictionaryPageSize;
    private final boolean enableDictionary;
    private final boolean validating;
    private final ParquetProperties.WriterVersion writerVersion;
    private long recordCount = 0L;
    private long recordCountForNextMemCheck = 100L;
    private ColumnWriteStoreImpl store;
    private ColumnChunkPageWriteStore pageStore;
    private ByteBufferAllocator allocator;

    public InternalParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, int blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, ByteBufferAllocator allocator) {
        this.w = w;
        this.writeSupport = (WriteSupport)Preconditions.checkNotNull(writeSupport, (String)"writeSupport");
        this.schema = schema;
        this.extraMetaData = extraMetaData;
        this.blockSize = blockSize;
        this.pageSize = pageSize;
        this.compressor = compressor;
        this.dictionaryPageSize = dictionaryPageSize;
        this.enableDictionary = enableDictionary;
        this.validating = validating;
        this.writerVersion = writerVersion;
        this.allocator = allocator;
        this.initStore();
    }

    private void initStore() {
        int initialBlockBufferSize = Math.max(65536, this.blockSize / this.schema.getColumns().size() / 5);
        this.pageStore = new ColumnChunkPageWriteStore(this.compressor, this.schema, initialBlockBufferSize, this.allocator);
        int initialPageBufferSize = Math.max(65536, Math.min(this.pageSize + this.pageSize / 10, initialBlockBufferSize));
        this.store = new ColumnWriteStoreImpl((PageWriteStore)this.pageStore, this.pageSize, initialPageBufferSize, this.dictionaryPageSize, this.enableDictionary, this.writerVersion);
        MessageColumnIO columnIO = new ColumnIOFactory(this.validating).getColumnIO(this.schema);
        this.writeSupport.prepareForWrite(columnIO.getRecordWriter((ColumnWriteStore)this.store));
    }

    public void close() throws IOException, InterruptedException {
        this.flushStore();
        this.w.end(this.extraMetaData);
    }

    public void write(T value) throws IOException, InterruptedException {
        this.writeSupport.write(value);
        ++this.recordCount;
        this.checkBlockSizeReached();
    }

    private void checkBlockSizeReached() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.store.memSize();
            if (memSize > (long)this.blockSize) {
                LOG.info((Object)String.format("mem size %,d > %,d: flushing %,d records to disk.", memSize, this.blockSize, this.recordCount));
                this.flushStore();
                this.initStore();
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, this.recordCount / 2L), 10000L);
            } else {
                float recordSize = (float)memSize / (float)this.recordCount;
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, (this.recordCount + (long)((float)this.blockSize / recordSize)) / 2L), this.recordCount + 10000L);
                if (Log.DEBUG) {
                    LOG.debug((Object)String.format("Checked mem at %,d will check again at: %,d ", this.recordCount, this.recordCountForNextMemCheck));
                }
            }
        }
    }

    private void flushStore() throws IOException {
        LOG.info((Object)String.format("Flushing mem store to file. allocated memory: %,d", this.store.allocatedSize()));
        if (this.store.allocatedSize() > (long)(3 * this.blockSize)) {
            LOG.warn((Object)("Too much memory used: " + this.store.memUsageString()));
        }
        this.w.startBlock(this.recordCount);
        this.store.flush();
        this.pageStore.flushToFileWriter(this.w);
        this.recordCount = 0L;
        this.w.endBlock();
        this.store.close();
        this.pageStore.close();
        this.store = null;
        this.pageStore = null;
    }
}

