/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.page.DictionaryPage;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.format.PageHeader;
import parquet.format.Util;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.metadata.ColumnChunkMetaData;

public class ColumnChunkIncReadStore
implements PageReadStore {
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private CodecFactory codecFactory;
    private FileSystem fs;
    private Path path;
    private long rowCount;
    private Map<ColumnDescriptor, ColumnChunkIncPageReader> columns = new HashMap<ColumnDescriptor, ColumnChunkIncPageReader>();

    public ColumnChunkIncReadStore(long rowCount, CodecFactory codecFactory, FileSystem fs, Path path) {
        this.codecFactory = codecFactory;
        this.fs = fs;
        this.path = path;
        this.rowCount = rowCount;
    }

    public void addColumn(ColumnDescriptor descriptor, ColumnChunkMetaData metaData) throws IOException {
        FSDataInputStream in = this.fs.open(this.path);
        in.seek(metaData.getStartingPos());
        ColumnChunkIncPageReader reader = new ColumnChunkIncPageReader(metaData, in);
        this.columns.put(descriptor, reader);
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        return this.columns.get(descriptor);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    final class ColumnChunkIncPageReader
    implements PageReader {
        ColumnChunkMetaData metaData;
        long fileOffset;
        long size;
        private long valueReadSoFar = 0L;
        private DictionaryPage dictionaryPage;
        private FSDataInputStream in;
        private CodecFactory.BytesDecompressor decompressor;

        public ColumnChunkIncPageReader(ColumnChunkMetaData metaData, FSDataInputStream in) {
            this.metaData = metaData;
            this.size = metaData.getTotalSize();
            this.fileOffset = metaData.getStartingPos();
            this.in = in;
            this.decompressor = ColumnChunkIncReadStore.this.codecFactory.getDecompressor(metaData.getCodec());
        }

        public DictionaryPage readDictionaryPage() {
            if (this.dictionaryPage == null) {
                PageHeader pageHeader;
                block4: {
                    try {
                        long pos = this.in.getPos();
                        pageHeader = Util.readPageHeader((InputStream)this.in);
                        if (pageHeader.getDictionary_page_header() != null) break block4;
                        this.in.seek(pos);
                        return null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.dictionaryPage = new DictionaryPage(this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.getDictionary_page_header().getNum_values(), parquetMetadataConverter.getEncoding(pageHeader.dictionary_page_header.encoding));
                System.out.println(this.dictionaryPage);
            }
            return this.dictionaryPage;
        }

        public long getTotalValueCount() {
            return this.metaData.getValueCount();
        }

        public Page readPage() {
            try {
                while (this.valueReadSoFar < this.metaData.getValueCount()) {
                    PageHeader pageHeader = Util.readPageHeader((InputStream)this.in);
                    switch (pageHeader.type) {
                        case DICTIONARY_PAGE: {
                            if (this.dictionaryPage == null) {
                                this.dictionaryPage = new DictionaryPage(this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.uncompressed_page_size, parquetMetadataConverter.getEncoding(pageHeader.dictionary_page_header.encoding));
                                break;
                            }
                            this.in.skip((long)pageHeader.compressed_page_size);
                            break;
                        }
                        case DATA_PAGE: {
                            this.valueReadSoFar += (long)pageHeader.data_page_header.getNum_values();
                            return new Page(this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.data_page_header.num_values, pageHeader.uncompressed_page_size, parquetMetadataConverter.getEncoding(pageHeader.data_page_header.repetition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.definition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.encoding));
                        }
                        default: {
                            this.in.skip((long)pageHeader.compressed_page_size);
                        }
                    }
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

