/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDir
implements Vfs.Dir {
    final java.util.zip.ZipFile jarFile;

    public ZipDir(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public String getPath() {
        return this.jarFile.getName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Enumeration<? extends ZipEntry> entries;
                    {
                        this.entries = ZipDir.this.jarFile.entries();
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        while (this.entries.hasMoreElements()) {
                            ZipEntry entry = this.entries.nextElement();
                            if (entry.isDirectory()) continue;
                            return new ZipFile(ZipDir.this, entry);
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    public String toString() {
        return this.jarFile.getName();
    }
}

