/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBuilder
implements Predicate<String> {
    private final List<Predicate<String>> chain = Lists.newArrayList();

    public FilterBuilder exclude(String regex) {
        this.add(new Exclude(regex));
        return this;
    }

    public FilterBuilder add(Predicate<String> filter) {
        this.chain.add(filter);
        return this;
    }

    public String toString() {
        return Joiner.on(", ").join(this.chain);
    }

    public boolean apply(String regex) {
        boolean accept;
        boolean bl = accept = this.chain == null || this.chain.isEmpty() || this.chain.get(0) instanceof Exclude;
        if (this.chain != null) {
            for (Predicate<String> filter : this.chain) {
                if (accept && filter instanceof Include || !accept && filter instanceof Exclude) continue;
                accept = filter.apply(regex);
            }
        }
        return accept;
    }

    public static class Exclude
    extends Matcher {
        public Exclude(String patternString) {
            super(patternString);
        }

        public boolean apply(String regex) {
            return !this.pattern.matcher(regex).matches();
        }

        public String toString() {
            return "-" + this.pattern.pattern();
        }
    }

    public static class Include
    extends Matcher {
        public boolean apply(String regex) {
            return this.pattern.matcher(regex).matches();
        }

        public String toString() {
            return "+" + super.toString();
        }
    }

    public static abstract class Matcher
    extends FilterBuilder {
        final Pattern pattern;

        public Matcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public abstract boolean apply(String var1);

        public String toString() {
            return this.pattern.pattern();
        }
    }
}

