/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections
extends ReflectionUtils {
    @Nullable
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    private Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration.getExecutorService() != null);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(scanner.getClass().getSimpleName()));
            }
            this.scan();
        }
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scan() {
        block19: {
            block20: {
                if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
                    if (Reflections.log != null) {
                        Reflections.log.error("given scan urls are empty. set urls in the configuration");
                    }
                    return;
                }
                if (Reflections.log != null && Reflections.log.isDebugEnabled()) {
                    urls = new StringBuilder();
                    for (URL url : this.configuration.getUrls()) {
                        urls.append("\t").append(url.toExternalForm()).append("\n");
                    }
                    Reflections.log.debug("going to scan these urls:\n" + urls);
                }
                time = System.currentTimeMillis();
                scannedUrls = 0;
                executorService = this.configuration.getExecutorService();
                if (executorService != null) break block20;
                i$ = this.configuration.getUrls().iterator();
                ** GOTO lbl23
            }
            futures = Lists.newArrayList();
            try {
                block21: {
                    i$ = this.configuration.getUrls().iterator();
                    break block21;
lbl23:
                    // 4 sources

                    while (i$.hasNext()) {
                        url = i$.next();
                        try {
                            for (Vfs.File file : Vfs.fromURL(url).getFiles()) {
                                this.scan(file);
                            }
                            ++scannedUrls;
                        }
                        catch (ReflectionsException var7_11) {
                            if (Reflections.log == null) continue;
                            Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", var7_11);
                        }
                    }
                    break block19;
                }
                while (i$.hasNext()) {
                    var7_12 = i$.next();
                    try {
                        for (final Vfs.File file : Vfs.fromURL(var7_12).getFiles()) {
                            futures.add(executorService.submit(new Runnable(){

                                public void run() {
                                    Reflections.this.scan(file);
                                }
                            }));
                        }
                        ++scannedUrls;
                    }
                    catch (ReflectionsException e) {
                        if (Reflections.log == null) continue;
                        Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", e);
                    }
                }
                for (Future var7_14 : futures) {
                    try {
                        var7_14.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        time = System.currentTimeMillis() - time;
        keys = this.store.getKeysCount();
        values = this.store.getValuesCount();
        if (Reflections.log != null) {
            Reflections.log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", new Object[]{time, scannedUrls, keys, values, executorService != null && executorService instanceof ThreadPoolExecutor != false ? String.format("[using %d cores]", new Object[]{((ThreadPoolExecutor)executorService).getMaximumPoolSize()}) : ""}));
        }
    }

    private void scan(Vfs.File file) {
        String input = file.getRelativePath().replace('/', '.');
        if (this.configuration.acceptsInput(input)) {
            for (Scanner scanner : this.configuration.getScanners()) {
                try {
                    if (!scanner.acceptsInput(input)) continue;
                    scanner.scan(file);
                }
                catch (Exception e) {
                    log.warn("could not scan file " + file.toString() + " with scanner " + scanner.getClass().getSimpleName(), e);
                }
            }
        }
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> subTypes = this.store.getSubTypesOf(type.getName());
        return this.toClasses(subTypes);
    }

    private <T> Set<Class<? extends T>> toClasses(Set<String> names) {
        return Sets.newHashSet(ReflectionUtils.forNames(names, this.configuration.getClassLoaders()));
    }
}

