/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodFormatterBuilder {
    private int iMinPrintedDigits;
    private int iPrintZeroSetting;
    private int iMaxParsedDigits;
    private boolean iRejectSignedValues;
    private PeriodFieldAffix iPrefix;
    private List<Object> iElementPairs;
    private boolean iNotPrinter;
    private boolean iNotParser;
    private FieldFormatter[] iFieldFormatters;

    public PeriodFormatterBuilder() {
        this.clear();
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return periodFormatter;
    }

    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iElementPairs == null) {
            this.iElementPairs = new ArrayList<Object>();
        } else {
            this.iElementPairs.clear();
        }
        this.iNotPrinter = false;
        this.iNotParser = false;
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder appendLiteral(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal = new Literal(string);
        this.append0(literal, literal);
        return this;
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    private void appendField(int n) {
        this.appendField(n, this.iMinPrintedDigits);
    }

    private void appendField(int n, int n2) {
        FieldFormatter fieldFormatter = new FieldFormatter(n2, this.iPrintZeroSetting, this.iMaxParsedDigits, this.iRejectSignedValues, n, this.iFieldFormatters, this.iPrefix, null);
        this.append0(fieldFormatter, fieldFormatter);
        this.iFieldFormatters[n] = fieldFormatter;
        this.iPrefix = null;
    }

    public PeriodFormatterBuilder appendSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(string));
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix periodFieldAffix) {
        Object object;
        Object object2;
        if (this.iElementPairs.size() > 0) {
            object2 = this.iElementPairs.get(this.iElementPairs.size() - 2);
            object = this.iElementPairs.get(this.iElementPairs.size() - 1);
        } else {
            object2 = null;
            object = null;
        }
        if (object2 == null || object == null || object2 != object || !(object2 instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        this.clearPrefix();
        FieldFormatter fieldFormatter = new FieldFormatter((FieldFormatter)object2, periodFieldAffix);
        this.iElementPairs.set(this.iElementPairs.size() - 2, fieldFormatter);
        this.iElementPairs.set(this.iElementPairs.size() - 1, fieldFormatter);
        this.iFieldFormatters[fieldFormatter.getFieldType()] = fieldFormatter;
        return this;
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String string) {
        return this.appendSeparator(string, string, null, false, true);
    }

    private PeriodFormatterBuilder appendSeparator(String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        this.clearPrefix();
        List<Object> list = this.iElementPairs;
        if (list.size() == 0) {
            if (bl2 && !bl) {
                Separator separator = new Separator(string, string2, stringArray, Literal.EMPTY, Literal.EMPTY, bl, bl2);
                this.append0(separator, separator);
            }
            return this;
        }
        Separator separator = null;
        int n = list.size();
        while (--n >= 0) {
            if (list.get(n) instanceof Separator) {
                separator = (Separator)list.get(n);
                list = list.subList(n + 1, list.size());
                break;
            }
            --n;
        }
        if (separator != null && list.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        list.clear();
        Separator separator2 = new Separator(string, string2, stringArray, (PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1], bl, bl2);
        list.add(separator2);
        list.add(separator2);
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private PeriodFormatterBuilder append0(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        this.iElementPairs.add(periodPrinter);
        this.iElementPairs.add(periodParser);
        this.iNotPrinter |= periodPrinter == null;
        this.iNotParser |= periodParser == null;
        return this;
    }

    private static PeriodFormatter toFormatter(List<Object> list, boolean bl, boolean bl2) {
        Object object;
        if (bl && bl2) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int n = list.size();
        if (n >= 2 && list.get(0) instanceof Separator && ((Separator)(object = (Separator)list.get(0))).iAfterParser == null && ((Separator)object).iAfterPrinter == null) {
            PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(list.subList(2, n), bl, bl2);
            object = ((Separator)object).finish(periodFormatter.getPrinter(), periodFormatter.getParser());
            return new PeriodFormatter((PeriodPrinter)object, (PeriodParser)object);
        }
        object = PeriodFormatterBuilder.createComposite(list);
        if (bl) {
            return new PeriodFormatter(null, (PeriodParser)object[1]);
        }
        if (bl2) {
            return new PeriodFormatter((PeriodPrinter)object[0], null);
        }
        return new PeriodFormatter((PeriodPrinter)object[0], (PeriodParser)object[1]);
    }

    private static Object[] createComposite(List<Object> list) {
        switch (list.size()) {
            case 0: {
                return new Object[]{Literal.EMPTY, Literal.EMPTY};
            }
            case 1: {
                return new Object[]{list.get(0), list.get(1)};
            }
        }
        Composite composite = new Composite(list);
        return new Object[]{composite, composite};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Composite
    implements PeriodParser,
    PeriodPrinter {
        private final PeriodPrinter[] iPrinters;
        private final PeriodParser[] iParsers;

        Composite(List<Object> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            this.iPrinters = arrayList.size() <= 0 ? null : arrayList.toArray(new PeriodPrinter[arrayList.size()]);
            this.iParsers = arrayList2.size() <= 0 ? null : arrayList2.toArray(new PeriodParser[arrayList2.size()]);
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            int n2;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n3 = periodPrinterArray.length;
            for (n2 = 0; n2 < n && --n3 >= 0; n2 += periodPrinterArray[n3].countFieldsToPrint(readablePeriod, Integer.MAX_VALUE, locale)) {
            }
            return n2;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            int n = 0;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = periodPrinterArray.length;
            while (--n2 >= 0) {
                n += periodPrinterArray[n2].calculatePrintedLength(readablePeriod, locale);
            }
            return n;
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n = periodPrinterArray.length;
            for (int i = 0; i < n; ++i) {
                periodPrinterArray[i].printTo(stringBuffer, readablePeriod, locale);
            }
        }

        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n = list.size();
            for (int i = 0; i < n; i += 2) {
                Object object = list.get(i);
                if (object instanceof PeriodPrinter) {
                    if (object instanceof Composite) {
                        this.addArrayToList(list2, ((Composite)object).iPrinters);
                    } else {
                        list2.add(object);
                    }
                }
                if (!((object = list.get(i + 1)) instanceof PeriodParser)) continue;
                if (object instanceof Composite) {
                    this.addArrayToList(list3, ((Composite)object).iParsers);
                    continue;
                }
                list3.add(object);
            }
        }

        private void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.add(objectArray[i]);
                }
            }
        }
    }

    static class Separator
    implements PeriodParser,
    PeriodPrinter {
        private final String iText;
        private final String iFinalText;
        private final String[] iParsedForms;
        private final boolean iUseBefore;
        private final boolean iUseAfter;
        private final PeriodPrinter iBeforePrinter;
        private volatile PeriodPrinter iAfterPrinter;
        private final PeriodParser iBeforeParser;
        private volatile PeriodParser iAfterParser;

        Separator(String string, String string2, String[] stringArray, PeriodPrinter periodPrinter, PeriodParser periodParser, boolean bl, boolean bl2) {
            this.iText = string;
            this.iFinalText = string2;
            if (!(string2 != null && !string.equals(string2) || stringArray != null && stringArray.length != 0)) {
                this.iParsedForms = new String[]{string};
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                treeSet.add(string);
                treeSet.add(string2);
                if (stringArray != null) {
                    int n = stringArray.length;
                    while (--n >= 0) {
                        treeSet.add(stringArray[n]);
                    }
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.reverse(arrayList);
                this.iParsedForms = arrayList.toArray(new String[arrayList.size()]);
            }
            this.iBeforePrinter = periodPrinter;
            this.iBeforeParser = periodParser;
            this.iUseBefore = bl;
            this.iUseAfter = bl2;
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            int n2 = this.iBeforePrinter.countFieldsToPrint(readablePeriod, n, locale);
            if (n2 < n) {
                n2 += this.iAfterPrinter.countFieldsToPrint(readablePeriod, n, locale);
            }
            return n2;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            int n = periodPrinter.calculatePrintedLength(readablePeriod, locale) + periodPrinter2.calculatePrintedLength(readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n2 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n2 > 0) {
                            n += (n2 > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        n += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                n += this.iText.length();
            }
            return n;
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(stringBuffer, readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n > 0) {
                            stringBuffer.append(n > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        stringBuffer.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                stringBuffer.append(this.iText);
            }
            periodPrinter2.printTo(stringBuffer, readablePeriod, locale);
        }

        Separator finish(PeriodPrinter periodPrinter, PeriodParser periodParser) {
            this.iAfterPrinter = periodPrinter;
            this.iAfterParser = periodParser;
            return this;
        }
    }

    static class Literal
    implements PeriodParser,
    PeriodPrinter {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String string) {
            this.iText = string;
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            return 0;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            return this.iText.length();
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            stringBuffer.append(this.iText);
        }
    }

    static class FieldFormatter
    implements PeriodParser,
    PeriodPrinter {
        private final int iMinPrintedDigits;
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final boolean iRejectSignedValues;
        private final int iFieldType;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int n, int n2, int n3, boolean bl, int n4, FieldFormatter[] fieldFormatterArray, PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iMinPrintedDigits = n;
            this.iPrintZeroSetting = n2;
            this.iMaxParsedDigits = n3;
            this.iRejectSignedValues = bl;
            this.iFieldType = n4;
            this.iFieldFormatters = fieldFormatterArray;
            this.iPrefix = periodFieldAffix;
            this.iSuffix = periodFieldAffix2;
        }

        FieldFormatter(FieldFormatter fieldFormatter, PeriodFieldAffix periodFieldAffix) {
            this.iMinPrintedDigits = fieldFormatter.iMinPrintedDigits;
            this.iPrintZeroSetting = fieldFormatter.iPrintZeroSetting;
            this.iMaxParsedDigits = fieldFormatter.iMaxParsedDigits;
            this.iRejectSignedValues = fieldFormatter.iRejectSignedValues;
            this.iFieldType = fieldFormatter.iFieldType;
            this.iFieldFormatters = fieldFormatter.iFieldFormatters;
            this.iPrefix = fieldFormatter.iPrefix;
            if (fieldFormatter.iSuffix != null) {
                periodFieldAffix = new CompositeAffix(fieldFormatter.iSuffix, periodFieldAffix);
            }
            this.iSuffix = periodFieldAffix;
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            if (n <= 0) {
                return 0;
            }
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(readablePeriod) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            long l = this.getFieldValue(readablePeriod);
            if (l == Long.MAX_VALUE) {
                return 0;
            }
            int n = Math.max(FormatUtils.calculateDigitCount(l), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                n = l < 0L ? Math.max(n, 5) : Math.max(n, 4);
                ++n;
                if (this.iFieldType == 9 && Math.abs(l) % 1000L == 0L) {
                    n -= 4;
                }
                l /= 1000L;
            }
            int n2 = (int)l;
            if (this.iPrefix != null) {
                n += this.iPrefix.calculatePrintedLength(n2);
            }
            if (this.iSuffix != null) {
                n += this.iSuffix.calculatePrintedLength(n2);
            }
            return n;
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            long l = this.getFieldValue(readablePeriod);
            if (l == Long.MAX_VALUE) {
                return;
            }
            int n = (int)l;
            if (this.iFieldType >= 8) {
                n = (int)(l / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(stringBuffer, n);
            }
            int n2 = stringBuffer.length();
            int n3 = this.iMinPrintedDigits;
            if (n3 <= 1) {
                FormatUtils.appendUnpaddedInteger(stringBuffer, n);
            } else {
                FormatUtils.appendPaddedInteger(stringBuffer, n, n3);
            }
            if (this.iFieldType >= 8) {
                int n4 = (int)(Math.abs(l) % 1000L);
                if (this.iFieldType == 8 || n4 > 0) {
                    if (l < 0L && l > -1000L) {
                        stringBuffer.insert(n2, '-');
                    }
                    stringBuffer.append('.');
                    FormatUtils.appendPaddedInteger(stringBuffer, n4, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(stringBuffer, n);
            }
        }

        long getFieldValue(ReadablePeriod readablePeriod) {
            int n;
            long l;
            PeriodType periodType = this.iPrintZeroSetting == 4 ? null : readablePeriod.getPeriodType();
            if (periodType != null && !this.isSupported(periodType, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    l = readablePeriod.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    l = readablePeriod.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    l = readablePeriod.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    l = readablePeriod.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    l = readablePeriod.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    l = readablePeriod.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    l = readablePeriod.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    l = readablePeriod.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    n = readablePeriod.get(DurationFieldType.seconds());
                    int n2 = readablePeriod.get(DurationFieldType.millis());
                    l = (long)n * 1000L + (long)n2;
                }
            }
            if (l == 0L) {
                switch (this.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        if (this.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            for (n = this.iFieldType + 1; n <= 9; ++n) {
                                if (!this.isSupported(periodType, n) || this.iFieldFormatters[n] == null) continue;
                                return Long.MAX_VALUE;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        if (this.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            n = Math.min(this.iFieldType, 8);
                            --n;
                            while (n >= 0 && n <= 9) {
                                if (this.isSupported(periodType, n) && this.iFieldFormatters[n] != null) {
                                    return Long.MAX_VALUE;
                                }
                                --n;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return l;
        }

        boolean isZero(ReadablePeriod readablePeriod) {
            int n = readablePeriod.size();
            for (int i = 0; i < n; ++i) {
                if (readablePeriod.getValue(i) == 0) continue;
                return false;
            }
            return true;
        }

        boolean isSupported(PeriodType periodType, int n) {
            switch (n) {
                default: {
                    return false;
                }
                case 0: {
                    return periodType.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return periodType.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return periodType.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return periodType.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return periodType.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return periodType.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return periodType.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return periodType.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return periodType.isSupported(DurationFieldType.seconds()) || periodType.isSupported(DurationFieldType.millis());
        }

        int getFieldType() {
            return this.iFieldType;
        }
    }

    static class CompositeAffix
    implements PeriodFieldAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;

        CompositeAffix(PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iLeft = periodFieldAffix;
            this.iRight = periodFieldAffix2;
        }

        public int calculatePrintedLength(int n) {
            return this.iLeft.calculatePrintedLength(n) + this.iRight.calculatePrintedLength(n);
        }

        public void printTo(StringBuffer stringBuffer, int n) {
            this.iLeft.printTo(stringBuffer, n);
            this.iRight.printTo(stringBuffer, n);
        }
    }

    static class SimpleAffix
    implements PeriodFieldAffix {
        private final String iText;

        SimpleAffix(String string) {
            this.iText = string;
        }

        public int calculatePrintedLength(int n) {
            return this.iText.length();
        }

        public void printTo(StringBuffer stringBuffer, int n) {
            stringBuffer.append(this.iText);
        }
    }

    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public void printTo(StringBuffer var1, int var2);
    }
}

